/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.OldCertUtil;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.SSLSessionUtil;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;

abstract class ProvSSLSessionBase
extends BCExtendedSSLSession {
    protected final Map<String, Object> valueMap = Collections.synchronizedMap(new HashMap());
    protected final AtomicReference<ProvSSLSessionContext> sslSessionContext;
    protected final boolean isFips;
    protected final JcaTlsCrypto crypto;
    protected final String peerHost;
    protected final int peerPort;
    protected final long creationTime;
    protected final SSLSession exportSSLSession;
    protected final AtomicLong lastAccessedTime;

    ProvSSLSessionBase(ProvSSLSessionContext provSSLSessionContext, String string, int n) {
        this.sslSessionContext = new AtomicReference<ProvSSLSessionContext>(provSSLSessionContext);
        this.isFips = null == provSSLSessionContext ? false : provSSLSessionContext.getSSLContext().isFips();
        this.crypto = null == provSSLSessionContext ? null : provSSLSessionContext.getCrypto();
        this.peerHost = string;
        this.peerPort = n;
        this.creationTime = System.currentTimeMillis();
        this.exportSSLSession = SSLSessionUtil.exportSSLSession(this);
        this.lastAccessedTime = new AtomicLong(this.creationTime);
    }

    protected abstract int getCipherSuiteTLS();

    protected abstract byte[] getIDArray();

    protected abstract JsseSecurityParameters getJsseSecurityParameters();

    protected abstract JsseSessionParameters getJsseSessionParameters();

    protected abstract Certificate getLocalCertificateTLS();

    protected abstract Certificate getPeerCertificateTLS();

    protected abstract ProtocolVersion getProtocolTLS();

    protected abstract void invalidateTLS();

    SSLSession getExportSSLSession() {
        return this.exportSSLSession;
    }

    void accessedAt(long l) {
        long l2 = this.lastAccessedTime.get();
        if (l > l2) {
            this.lastAccessedTime.compareAndSet(l2, l);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProvSSLSessionBase)) {
            return false;
        }
        ProvSSLSessionBase provSSLSessionBase = (ProvSSLSessionBase)object;
        return Arrays.areEqual((byte[])this.getIDArray(), (byte[])provSSLSessionBase.getIDArray());
    }

    public int getApplicationBufferSize() {
        return 16384;
    }

    public String getCipherSuite() {
        return ProvSSLContextSpi.getCipherSuiteName(this.getCipherSuiteTLS());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public byte[] getId() {
        byte[] byArray = this.getIDArray();
        return TlsUtils.isNullOrEmpty(byArray) ? TlsUtils.EMPTY_BYTES : (byte[])byArray.clone();
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime.get();
    }

    public java.security.cert.Certificate[] getLocalCertificates() {
        java.security.cert.Certificate[] certificateArray;
        if (null != this.crypto && null != (certificateArray = JsseUtils.getX509CertificateChain(this.crypto, this.getLocalCertificateTLS())) && certificateArray.length > 0) {
            return certificateArray;
        }
        return null;
    }

    public Principal getLocalPrincipal() {
        if (null != this.crypto) {
            return JsseUtils.getSubject(this.crypto, this.getLocalCertificateTLS());
        }
        return null;
    }

    public int getPacketBufferSize() {
        ProtocolVersion protocolVersion = this.getProtocolTLS();
        if (null == protocolVersion || !TlsUtils.isTLSv11(protocolVersion)) {
            return 18443;
        }
        if (TlsUtils.isTLSv13(protocolVersion)) {
            return 16911;
        }
        return 17413;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        return OldCertUtil.getPeerCertificateChain(this);
    }

    public java.security.cert.Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        java.security.cert.Certificate[] certificateArray;
        if (null != this.crypto && null != (certificateArray = JsseUtils.getX509CertificateChain(this.crypto, this.getPeerCertificateTLS())) && certificateArray.length > 0) {
            return certificateArray;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        X500Principal x500Principal;
        if (null != this.crypto && null != (x500Principal = JsseUtils.getSubject(this.crypto, this.getPeerCertificateTLS()))) {
            return x500Principal;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getProtocol() {
        return ProvSSLContextSpi.getProtocolVersionName(this.getProtocolTLS());
    }

    public SSLSessionContext getSessionContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.sslSessionContext.get();
    }

    public Object getValue(String string) {
        return this.valueMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        Map<String, Object> map = this.valueMap;
        synchronized (map) {
            return this.valueMap.keySet().toArray(new String[this.valueMap.size()]);
        }
    }

    public int hashCode() {
        return Arrays.hashCode((byte[])this.getIDArray());
    }

    public final void invalidate() {
        this.implInvalidate(true);
    }

    final void invalidatedBySessionContext() {
        this.implInvalidate(false);
    }

    public boolean isFipsMode() {
        return this.isFips;
    }

    public boolean isValid() {
        if (null == this.sslSessionContext.get()) {
            return false;
        }
        return !TlsUtils.isNullOrEmpty(this.getIDArray());
    }

    public void putValue(String string, Object object) {
        this.notifyUnbound(string, this.valueMap.put(string, object));
        this.notifyBound(string, object);
    }

    public void removeValue(String string) {
        this.notifyUnbound(string, this.valueMap.remove(string));
    }

    public String toString() {
        return "Session(" + this.getCreationTime() + "|" + this.getCipherSuite() + ")";
    }

    protected void notifyBound(String string, Object object) {
        if (object instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)object).valueBound(new SSLSessionBindingEvent(this, string));
        }
    }

    protected void notifyUnbound(String string, Object object) {
        if (object instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)object).valueUnbound(new SSLSessionBindingEvent(this, string));
        }
    }

    private void implInvalidate(boolean bl) {
        if (bl) {
            ProvSSLSessionContext provSSLSessionContext = this.sslSessionContext.getAndSet(null);
            if (null != provSSLSessionContext) {
                provSSLSessionContext.removeSession(this.getIDArray());
            }
        } else {
            this.sslSessionContext.set(null);
        }
        this.invalidateTLS();
    }
}

