/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.jcajce.spec.DHDomainParameterSpec;
import org.bouncycastle.jcajce.spec.DHExtendedPublicKeySpec;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

class DHUtil {
    DHUtil() {
    }

    static AlgorithmParameterSpec createInitSpec(DHGroup dHGroup) {
        return new DHDomainParameterSpec(dHGroup.getP(), dHGroup.getQ(), dHGroup.getG(), dHGroup.getL());
    }

    static KeySpec createPublicKeySpec(BigInteger bigInteger, DHParameterSpec dHParameterSpec) {
        return new DHExtendedPublicKeySpec(bigInteger, dHParameterSpec);
    }

    static AlgorithmParameters getAlgorithmParameters(JcaTlsCrypto jcaTlsCrypto, DHGroup dHGroup) {
        return DHUtil.getAlgorithmParameters(jcaTlsCrypto, DHUtil.createInitSpec(dHGroup));
    }

    static AlgorithmParameters getAlgorithmParameters(JcaTlsCrypto jcaTlsCrypto, AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            AlgorithmParameters algorithmParameters = jcaTlsCrypto.getHelper().createAlgorithmParameters("DiffieHellman");
            algorithmParameters.init(algorithmParameterSpec);
            DHParameterSpec dHParameterSpec = algorithmParameters.getParameterSpec(DHParameterSpec.class);
            if (null != dHParameterSpec) {
                return algorithmParameters;
            }
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static DHParameterSpec getDHParameterSpec(JcaTlsCrypto jcaTlsCrypto, DHGroup dHGroup) {
        return DHUtil.getDHParameterSpec(jcaTlsCrypto, DHUtil.createInitSpec(dHGroup));
    }

    static DHParameterSpec getDHParameterSpec(JcaTlsCrypto jcaTlsCrypto, AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            AlgorithmParameters algorithmParameters = jcaTlsCrypto.getHelper().createAlgorithmParameters("DiffieHellman");
            algorithmParameters.init(algorithmParameterSpec);
            DHParameterSpec dHParameterSpec = algorithmParameters.getParameterSpec(DHParameterSpec.class);
            if (null != dHParameterSpec) {
                return dHParameterSpec;
            }
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static BigInteger getQ(DHParameterSpec dHParameterSpec) {
        return dHParameterSpec instanceof DHDomainParameterSpec ? ((DHDomainParameterSpec)dHParameterSpec).getQ() : null;
    }

    static boolean isGroupSupported(JcaTlsCrypto jcaTlsCrypto, DHGroup dHGroup) {
        return null != dHGroup && null != DHUtil.getDHParameterSpec(jcaTlsCrypto, dHGroup);
    }
}

