/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsMLKemDomain;

public class JceTlsMLKem
implements TlsAgreement {
    protected final JceTlsMLKemDomain domain;
    protected MLKEMPrivateKeyParameters privateKey;
    protected MLKEMPublicKeyParameters publicKey;
    protected TlsSecret secret;

    public JceTlsMLKem(JceTlsMLKemDomain jceTlsMLKemDomain) {
        this.domain = jceTlsMLKemDomain;
    }

    public byte[] generateEphemeral() throws IOException {
        if (this.domain.isServer()) {
            SecretWithEncapsulation secretWithEncapsulation = this.domain.encapsulate(this.publicKey);
            this.publicKey = null;
            this.secret = this.domain.adoptLocalSecret(secretWithEncapsulation.getSecret());
            return secretWithEncapsulation.getEncapsulation();
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.domain.generateKeyPair();
        this.privateKey = (MLKEMPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return this.domain.encodePublicKey((MLKEMPublicKeyParameters)asymmetricCipherKeyPair.getPublic());
    }

    public void receivePeerValue(byte[] byArray) throws IOException {
        if (this.domain.isServer()) {
            this.publicKey = this.domain.decodePublicKey(byArray);
        } else {
            this.secret = this.domain.decapsulate(this.privateKey, byArray);
            this.privateKey = null;
        }
    }

    public TlsSecret calculateSecret() throws IOException {
        TlsSecret tlsSecret = this.secret;
        this.secret = null;
        return tlsSecret;
    }
}

