/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsPeer;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.MaxFragmentLength;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPSKExternal;
import org.bouncycastle.tls.TlsPSKIdentityManager;
import org.bouncycastle.tls.TlsSRPLoginParameters;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContext;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsECConfig;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractTlsServer
extends AbstractTlsPeer
implements TlsServer {
    protected TlsServerContext context;
    protected ProtocolVersion[] protocolVersions;
    protected int[] cipherSuites;
    protected int[] offeredCipherSuites;
    protected Hashtable clientExtensions;
    protected boolean encryptThenMACOffered;
    protected short maxFragmentLengthOffered;
    protected boolean truncatedHMacOffered;
    protected boolean clientSentECPointFormats;
    protected CertificateStatusRequest certificateStatusRequest;
    protected Vector statusRequestV2;
    protected Vector trustedCAKeys;
    protected int selectedCipherSuite;
    protected Vector clientProtocolNames;
    protected ProtocolName selectedProtocolName;
    protected final Hashtable serverExtensions = new Hashtable();

    public AbstractTlsServer(TlsCrypto tlsCrypto) {
        super(tlsCrypto);
    }

    protected boolean allowCertificateStatus() {
        return true;
    }

    protected boolean allowEncryptThenMAC() {
        return true;
    }

    protected boolean allowMultiCertStatus() {
        return false;
    }

    protected boolean allowTruncatedHMac() {
        return false;
    }

    protected boolean allowTrustedCAIndication() {
        return false;
    }

    protected Hashtable checkServerExtensions() {
        return this.serverExtensions;
    }

    protected int getMaximumNegotiableCurveBits() {
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (nArray == null) {
            return NamedGroup.getMaximumCurveBits();
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.max(n, NamedGroup.getCurveBits(nArray[i]));
        }
        return n;
    }

    protected int getMaximumNegotiableFiniteFieldBits() {
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (nArray == null) {
            return NamedGroup.getMaximumFiniteFieldBits();
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.max(n, NamedGroup.getFiniteFieldBits(nArray[i]));
        }
        return n;
    }

    protected Vector getProtocolNames() {
        return null;
    }

    protected boolean isSelectableCipherSuite(int n, int n2, int n3, Vector vector) {
        return TlsUtils.isValidVersionForCipherSuite(n, this.context.getServerVersion()) && n2 >= TlsECCUtils.getMinimumCurveBits(n) && n3 >= TlsDHUtils.getMinimumFiniteFieldBits(n) && TlsUtils.isValidCipherSuiteForSignatureAlgorithms(n, vector);
    }

    protected boolean preferLocalCipherSuites() {
        return false;
    }

    protected boolean selectCipherSuite(int n) throws IOException {
        this.selectedCipherSuite = n;
        return true;
    }

    protected int selectDH(int n) {
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (nArray == null) {
            return this.selectDHDefault(n);
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (NamedGroup.getFiniteFieldBits(n2) < n) continue;
            return n2;
        }
        return -1;
    }

    protected int selectDHDefault(int n) {
        return n <= 2048 ? 256 : (n <= 3072 ? 257 : (n <= 4096 ? 258 : (n <= 6144 ? 259 : (n <= 8192 ? 260 : -1))));
    }

    protected int selectECDH(int n) {
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (nArray == null) {
            return this.selectECDHDefault(n);
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (NamedGroup.getCurveBits(n2) < n) continue;
            return n2;
        }
        return -1;
    }

    protected int selectECDHDefault(int n) {
        return n <= 256 ? 23 : (n <= 384 ? 24 : (n <= 521 ? 25 : -1));
    }

    protected ProtocolName selectProtocolName() throws IOException {
        Vector vector = this.getProtocolNames();
        if (null == vector || vector.isEmpty()) {
            return null;
        }
        ProtocolName protocolName = this.selectProtocolName(this.clientProtocolNames, vector);
        if (null == protocolName) {
            throw new TlsFatalAlert(120);
        }
        return protocolName;
    }

    protected ProtocolName selectProtocolName(Vector vector, Vector vector2) {
        for (int i = 0; i < vector2.size(); ++i) {
            ProtocolName protocolName = (ProtocolName)vector2.elementAt(i);
            if (!vector.contains(protocolName)) continue;
            return protocolName;
        }
        return null;
    }

    protected boolean shouldSelectProtocolNameEarly() {
        return true;
    }

    protected boolean preferLocalClientCertificateTypes() {
        return false;
    }

    protected short[] getAllowedClientCertificateTypes() {
        return null;
    }

    @Override
    public void init(TlsServerContext tlsServerContext) {
        this.context = tlsServerContext;
        this.protocolVersions = this.getSupportedVersions();
        this.cipherSuites = this.getSupportedCipherSuites();
    }

    @Override
    public ProtocolVersion[] getProtocolVersions() {
        return this.protocolVersions;
    }

    @Override
    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        this.offeredCipherSuites = null;
        this.clientExtensions = null;
        this.encryptThenMACOffered = false;
        this.maxFragmentLengthOffered = 0;
        this.truncatedHMacOffered = false;
        this.clientSentECPointFormats = false;
        this.certificateStatusRequest = null;
        this.selectedCipherSuite = -1;
        this.selectedProtocolName = null;
        this.serverExtensions.clear();
    }

    @Override
    public TlsSession getSessionToResume(byte[] byArray) {
        return null;
    }

    @Override
    public byte[] getNewSessionID() {
        return null;
    }

    @Override
    public TlsPSKExternal getExternalPSK(Vector vector) {
        return null;
    }

    @Override
    public void notifySession(TlsSession tlsSession) {
    }

    @Override
    public void notifyClientVersion(ProtocolVersion protocolVersion) throws IOException {
    }

    @Override
    public void notifyFallback(boolean bl) throws IOException {
        if (bl) {
            ProtocolVersion protocolVersion;
            ProtocolVersion[] protocolVersionArray = this.getProtocolVersions();
            ProtocolVersion protocolVersion2 = this.context.getClientVersion();
            if (protocolVersion2.isTLS()) {
                protocolVersion = ProtocolVersion.getLatestTLS(protocolVersionArray);
            } else if (protocolVersion2.isDTLS()) {
                protocolVersion = ProtocolVersion.getLatestDTLS(protocolVersionArray);
            } else {
                throw new TlsFatalAlert(80);
            }
            if (null != protocolVersion && protocolVersion.isLaterVersionOf(protocolVersion2)) {
                throw new TlsFatalAlert(86);
            }
        }
    }

    @Override
    public void notifyOfferedCipherSuites(int[] nArray) throws IOException {
        this.offeredCipherSuites = nArray;
    }

    @Override
    public void processClientExtensions(Hashtable hashtable) throws IOException {
        this.clientExtensions = hashtable;
        if (null != hashtable) {
            this.clientProtocolNames = TlsExtensionsUtils.getALPNExtensionClient(hashtable);
            if (this.shouldSelectProtocolNameEarly() && null != this.clientProtocolNames && !this.clientProtocolNames.isEmpty()) {
                this.selectedProtocolName = this.selectProtocolName();
            }
            this.encryptThenMACOffered = TlsExtensionsUtils.hasEncryptThenMACExtension(hashtable);
            this.truncatedHMacOffered = TlsExtensionsUtils.hasTruncatedHMacExtension(hashtable);
            this.statusRequestV2 = TlsExtensionsUtils.getStatusRequestV2Extension(hashtable);
            this.trustedCAKeys = TlsExtensionsUtils.getTrustedCAKeysExtensionClient(hashtable);
            this.clientSentECPointFormats = null != TlsExtensionsUtils.getSupportedPointFormatsExtension(hashtable);
            this.certificateStatusRequest = TlsExtensionsUtils.getStatusRequestExtension(hashtable);
            this.maxFragmentLengthOffered = TlsExtensionsUtils.getMaxFragmentLengthExtension(hashtable);
            if (this.maxFragmentLengthOffered >= 0 && !MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
                throw new TlsFatalAlert(47);
            }
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion[] protocolVersionArray = this.getProtocolVersions();
        ProtocolVersion[] protocolVersionArray2 = this.context.getClientSupportedVersions();
        for (int i = 0; i < protocolVersionArray2.length; ++i) {
            ProtocolVersion protocolVersion = protocolVersionArray2[i];
            if (!ProtocolVersion.contains(protocolVersionArray, protocolVersion)) continue;
            return protocolVersion;
        }
        throw new TlsFatalAlert(70);
    }

    @Override
    public int[] getSupportedGroups() throws IOException {
        return new int[]{29, 30, 23, 24, 256, 257, 258};
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (TlsUtils.isTLSv13(protocolVersion)) {
            int n = TlsUtils.getCommonCipherSuite13(protocolVersion, this.offeredCipherSuites, this.getCipherSuites(), this.preferLocalCipherSuites());
            if (n >= 0 && this.selectCipherSuite(n)) {
                return n;
            }
        } else {
            Vector vector = TlsUtils.getUsableSignatureAlgorithms(securityParameters.getClientSigAlgs());
            int n = this.getMaximumNegotiableCurveBits();
            int n2 = this.getMaximumNegotiableFiniteFieldBits();
            int[] nArray = TlsUtils.getCommonCipherSuites(this.offeredCipherSuites, this.getCipherSuites(), this.preferLocalCipherSuites());
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                if (!this.isSelectableCipherSuite(n3, n, n2, vector) || !this.selectCipherSuite(n3)) continue;
                return n3;
            }
        }
        throw new TlsFatalAlert(40, "No selectable cipher suite");
    }

    @Override
    public Hashtable getServerExtensions() throws IOException {
        short[] sArray;
        Object object;
        short[] sArray2;
        boolean bl = TlsUtils.isTLSv13(this.context);
        if (bl) {
            if (null != this.certificateStatusRequest && this.allowCertificateStatus()) {
                // empty if block
            }
        } else {
            if (this.encryptThenMACOffered && this.allowEncryptThenMAC() && TlsUtils.isBlockCipherSuite(this.selectedCipherSuite)) {
                TlsExtensionsUtils.addEncryptThenMACExtension(this.serverExtensions);
            }
            if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
                TlsExtensionsUtils.addTruncatedHMacExtension(this.serverExtensions);
            }
            if (this.clientSentECPointFormats && TlsECCUtils.isECCCipherSuite(this.selectedCipherSuite)) {
                TlsExtensionsUtils.addSupportedPointFormatsExtension(this.serverExtensions, new short[]{0});
            }
            if (null != this.statusRequestV2 && this.allowMultiCertStatus()) {
                TlsExtensionsUtils.addEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request_v2);
            } else if (null != this.certificateStatusRequest && this.allowCertificateStatus()) {
                TlsExtensionsUtils.addEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request);
            }
            if (null != this.trustedCAKeys && this.allowTrustedCAIndication()) {
                TlsExtensionsUtils.addTrustedCAKeysExtensionServer(this.serverExtensions);
            }
        }
        if (this.maxFragmentLengthOffered >= 0 && MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension(this.serverExtensions, this.maxFragmentLengthOffered);
        }
        if ((sArray2 = TlsExtensionsUtils.getServerCertificateTypeExtensionClient(this.clientExtensions)) != null) {
            object = this.getCredentials();
            if (object == null || !TlsUtils.contains(sArray2, 0, sArray2.length, (int)object.getCertificate().getCertificateType())) {
                throw new TlsFatalAlert(43);
            }
            TlsExtensionsUtils.addServerCertificateTypeExtensionServer(this.serverExtensions, object.getCertificate().getCertificateType());
        }
        if ((object = (Object)TlsExtensionsUtils.getClientCertificateTypeExtensionClient(this.clientExtensions)) != null && (sArray = this.getAllowedClientCertificateTypes()) != null) {
            Object object2;
            Object object3;
            if (this.preferLocalClientCertificateTypes()) {
                object3 = sArray;
                object2 = object;
            } else {
                object3 = object;
                object2 = sArray;
            }
            short s = -1;
            for (int i = 0; i < ((short[])object3).length; ++i) {
                if (!TlsUtils.contains((short[])object2, 0, ((Object)object2).length, (int)object3[i])) continue;
                s = object3[i];
                break;
            }
            if (s == -1) {
                throw new TlsFatalAlert(43);
            }
            TlsExtensionsUtils.addClientCertificateTypeExtensionServer(this.serverExtensions, s);
        }
        return this.serverExtensions;
    }

    @Override
    public void getServerExtensionsForConnection(Hashtable hashtable) throws IOException {
        if (!this.shouldSelectProtocolNameEarly() && null != this.clientProtocolNames && !this.clientProtocolNames.isEmpty()) {
            this.selectedProtocolName = this.selectProtocolName();
        }
        if (null == this.selectedProtocolName) {
            hashtable.remove(TlsExtensionsUtils.EXT_application_layer_protocol_negotiation);
        } else {
            TlsExtensionsUtils.addALPNExtensionServer(hashtable, this.selectedProtocolName);
        }
    }

    @Override
    public Vector getServerSupplementalData() throws IOException {
        return null;
    }

    @Override
    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        return null;
    }

    @Override
    public TlsPSKIdentityManager getPSKIdentityManager() throws IOException {
        return null;
    }

    @Override
    public TlsSRPLoginParameters getSRPLoginParameters() throws IOException {
        return null;
    }

    @Override
    public TlsDHConfig getDHConfig() throws IOException {
        int n = TlsDHUtils.getMinimumFiniteFieldBits(this.selectedCipherSuite);
        int n2 = this.selectDH(n);
        return TlsDHUtils.createNamedDHConfig(this.context, n2);
    }

    @Override
    public TlsECConfig getECDHConfig() throws IOException {
        int n = TlsECCUtils.getMinimumCurveBits(this.selectedCipherSuite);
        int n2 = this.selectECDH(n);
        return TlsECCUtils.createNamedECConfig(this.context, n2);
    }

    @Override
    public void processClientSupplementalData(Vector vector) throws IOException {
        if (vector != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void notifyClientCertificate(Certificate certificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public NewSessionTicket getNewSessionTicket() throws IOException {
        return new NewSessionTicket(0L, TlsUtils.EMPTY_BYTES);
    }
}

