/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsContext;
import org.bouncycastle.tls.ByteQueue;
import org.bouncycastle.tls.ByteQueueInputStream;
import org.bouncycastle.tls.ByteQueueOutputStream;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DeferredHash;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.ExtensionType;
import org.bouncycastle.tls.HandshakeMessageInput;
import org.bouncycastle.tls.HandshakeMessageOutput;
import org.bouncycastle.tls.HandshakeType;
import org.bouncycastle.tls.KeyUpdateRequest;
import org.bouncycastle.tls.MaxFragmentLength;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.RecordPreview;
import org.bouncycastle.tls.RecordStream;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.SupplementalDataEntry;
import org.bouncycastle.tls.TlsCloseable;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsFatalAlertReceived;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsInputStream;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsNoCloseNotifyException;
import org.bouncycastle.tls.TlsOutputStream;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class TlsProtocol
implements TlsCloseable {
    protected static final Integer EXT_RenegotiationInfo = Integers.valueOf((int)65281);
    protected static final Integer EXT_SessionTicket = Integers.valueOf((int)35);
    protected static final short CS_START = 0;
    protected static final short CS_CLIENT_HELLO = 1;
    protected static final short CS_SERVER_HELLO_RETRY_REQUEST = 2;
    protected static final short CS_CLIENT_HELLO_RETRY = 3;
    protected static final short CS_SERVER_HELLO = 4;
    protected static final short CS_SERVER_ENCRYPTED_EXTENSIONS = 5;
    protected static final short CS_SERVER_SUPPLEMENTAL_DATA = 6;
    protected static final short CS_SERVER_CERTIFICATE = 7;
    protected static final short CS_SERVER_CERTIFICATE_STATUS = 8;
    protected static final short CS_SERVER_CERTIFICATE_VERIFY = 9;
    protected static final short CS_SERVER_KEY_EXCHANGE = 10;
    protected static final short CS_SERVER_CERTIFICATE_REQUEST = 11;
    protected static final short CS_SERVER_HELLO_DONE = 12;
    protected static final short CS_CLIENT_END_OF_EARLY_DATA = 13;
    protected static final short CS_CLIENT_SUPPLEMENTAL_DATA = 14;
    protected static final short CS_CLIENT_CERTIFICATE = 15;
    protected static final short CS_CLIENT_KEY_EXCHANGE = 16;
    protected static final short CS_CLIENT_CERTIFICATE_VERIFY = 17;
    protected static final short CS_CLIENT_FINISHED = 18;
    protected static final short CS_SERVER_SESSION_TICKET = 19;
    protected static final short CS_SERVER_FINISHED = 20;
    protected static final short CS_END = 21;
    protected static final short ADS_MODE_1_Nsub1 = 0;
    protected static final short ADS_MODE_0_N = 1;
    protected static final short ADS_MODE_0_N_FIRSTONLY = 2;
    private ByteQueue applicationDataQueue = new ByteQueue(0);
    private ByteQueue alertQueue = new ByteQueue(2);
    private ByteQueue handshakeQueue = new ByteQueue(0);
    final RecordStream recordStream;
    final Object recordWriteLock = new Object();
    private int maxHandshakeMessageSize = -1;
    TlsHandshakeHash handshakeHash;
    private TlsInputStream tlsInputStream = null;
    private TlsOutputStream tlsOutputStream = null;
    private volatile boolean closed = false;
    private volatile boolean failed = false;
    private volatile boolean appDataReady = false;
    private volatile boolean appDataSplitEnabled = true;
    private volatile boolean keyUpdateEnabled = false;
    private volatile boolean keyUpdatePendingSend = false;
    private volatile boolean resumableHandshake = false;
    private volatile int appDataSplitMode = 0;
    protected TlsSession tlsSession = null;
    protected SessionParameters sessionParameters = null;
    protected TlsSecret sessionMasterSecret = null;
    protected byte[] retryCookie = null;
    protected int retryGroup = -1;
    protected Hashtable clientExtensions = null;
    protected Hashtable serverExtensions = null;
    protected short connection_state = 0;
    protected boolean selectedPSK13 = false;
    protected boolean receivedChangeCipherSpec = false;
    protected boolean expectSessionTicket = false;
    protected boolean blocking;
    protected ByteQueueInputStream inputBuffers;
    protected ByteQueueOutputStream outputBuffer;

    protected boolean isLegacyConnectionState() {
        switch (this.connection_state) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    protected boolean isTLSv13ConnectionState() {
        switch (this.connection_state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    protected TlsProtocol() {
        this.blocking = false;
        this.inputBuffers = new ByteQueueInputStream();
        this.outputBuffer = new ByteQueueOutputStream();
        this.recordStream = new RecordStream(this, this.inputBuffers, this.outputBuffer);
    }

    protected TlsProtocol(InputStream inputStream, OutputStream outputStream) {
        this.blocking = true;
        this.recordStream = new RecordStream(this, inputStream, outputStream);
    }

    public void resumeHandshake() throws IOException {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use resumeHandshake() in non-blocking mode!");
        }
        if (!this.isHandshaking()) {
            throw new IllegalStateException("No handshake in progress");
        }
        this.blockForHandshake();
    }

    protected void closeConnection() throws IOException {
        this.recordStream.close();
    }

    protected abstract TlsContext getContext();

    abstract AbstractTlsContext getContextAdmin();

    protected abstract TlsPeer getPeer();

    protected int getRenegotiationPolicy() {
        return 0;
    }

    protected void handleAlertMessage(short s, short s2) throws IOException {
        this.getPeer().notifyAlertReceived(s, s2);
        if (s != 1) {
            this.handleFailure();
            throw new TlsFatalAlertReceived(s2);
        }
        this.handleAlertWarningMessage(s2);
    }

    protected void handleAlertWarningMessage(short s) throws IOException {
        switch (s) {
            case 0: {
                if (!this.appDataReady) {
                    throw new TlsFatalAlert(40);
                }
                this.handleClose(false);
                break;
            }
            case 41: {
                throw new TlsFatalAlert(10);
            }
            case 100: {
                throw new TlsFatalAlert(40);
            }
        }
    }

    protected void handleChangeCipherSpecMessage() throws IOException {
    }

    protected void handleClose(boolean bl) throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (!this.appDataReady) {
                this.cleanupHandshake();
                if (bl) {
                    this.raiseAlertWarning((short)90, "User canceled handshake");
                }
            }
            this.raiseAlertWarning((short)0, "Connection closed");
            this.closeConnection();
            this.getPeer().notifyConnectionClosed();
        }
    }

    protected void handleException(short s, String string, Throwable throwable) throws IOException {
        if ((this.appDataReady || this.isResumableHandshake()) && throwable instanceof InterruptedIOException) {
            return;
        }
        if (!this.closed) {
            this.raiseAlertFatal(s, string, throwable);
            this.handleFailure();
        }
    }

    protected void handleFailure() throws IOException {
        this.closed = true;
        this.failed = true;
        this.invalidateSession();
        if (!this.appDataReady) {
            this.cleanupHandshake();
        }
        this.closeConnection();
        this.getPeer().notifyConnectionClosed();
    }

    protected abstract void handleHandshakeMessage(short var1, HandshakeMessageInput var2) throws IOException;

    protected boolean handleRenegotiation() throws IOException {
        int n = 0;
        SecurityParameters securityParameters = this.getContext().getSecurityParametersConnection();
        if (null != securityParameters && securityParameters.isSecureRenegotiation() && (!securityParameters.isResumedSession() || securityParameters.isExtendedMasterSecret())) {
            Certificate certificate;
            Certificate certificate2 = certificate = 0 == securityParameters.getEntity() ? securityParameters.getLocalCertificate() : securityParameters.getPeerCertificate();
            if (null != certificate && !certificate.isEmpty()) {
                n = this.getRenegotiationPolicy();
            }
        }
        switch (n) {
            case 2: {
                this.beginHandshake(true);
                return true;
            }
            case 1: {
                return false;
            }
        }
        this.refuseRenegotiation();
        return false;
    }

    protected void applyMaxFragmentLengthExtension(short s) throws IOException {
        if (s >= 0) {
            if (!MaxFragmentLength.isValid(s)) {
                throw new TlsFatalAlert(80);
            }
            int n = 1 << 8 + s;
            this.recordStream.setPlaintextLimit(n);
        }
    }

    protected void checkReceivedChangeCipherSpec(boolean bl) throws IOException {
        if (bl != this.receivedChangeCipherSpec) {
            throw new TlsFatalAlert(10);
        }
    }

    protected void blockForHandshake() throws IOException {
        while (this.connection_state != 21) {
            if (this.isClosed()) {
                throw new TlsFatalAlert(80);
            }
            this.safeReadRecord();
        }
    }

    protected void beginHandshake(boolean bl) throws IOException {
        AbstractTlsContext abstractTlsContext = this.getContextAdmin();
        TlsPeer tlsPeer = this.getPeer();
        this.maxHandshakeMessageSize = Math.max(1024, tlsPeer.getMaxHandshakeMessageSize());
        this.handshakeHash = new DeferredHash(abstractTlsContext);
        this.connection_state = 0;
        this.selectedPSK13 = false;
        abstractTlsContext.handshakeBeginning(tlsPeer);
        SecurityParameters securityParameters = abstractTlsContext.getSecurityParametersHandshake();
        if (bl != securityParameters.isRenegotiating()) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.extendedPadding = tlsPeer.shouldUseExtendedPadding();
    }

    protected void cleanupHandshake() {
        SecurityParameters securityParameters;
        TlsContext tlsContext = this.getContext();
        if (null != tlsContext && null != (securityParameters = tlsContext.getSecurityParameters())) {
            securityParameters.clear();
        }
        this.tlsSession = null;
        this.sessionParameters = null;
        this.sessionMasterSecret = null;
        this.retryCookie = null;
        this.retryGroup = -1;
        this.clientExtensions = null;
        this.serverExtensions = null;
        this.selectedPSK13 = false;
        this.receivedChangeCipherSpec = false;
        this.expectSessionTicket = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeHandshake() throws IOException {
        try {
            AbstractTlsContext abstractTlsContext = this.getContextAdmin();
            SecurityParameters securityParameters = abstractTlsContext.getSecurityParametersHandshake();
            if (!abstractTlsContext.isHandshaking() || null == securityParameters.getLocalVerifyData() || null == securityParameters.getPeerVerifyData()) {
                throw new TlsFatalAlert(80);
            }
            this.recordStream.finaliseHandshake();
            this.connection_state = (short)21;
            this.handshakeHash = new DeferredHash(abstractTlsContext);
            this.alertQueue.shrink();
            this.handshakeQueue.shrink();
            ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
            this.appDataSplitEnabled = !TlsUtils.isTLSv11(protocolVersion);
            this.appDataReady = true;
            this.keyUpdateEnabled = TlsUtils.isTLSv13(protocolVersion);
            if (this.blocking) {
                this.tlsInputStream = new TlsInputStream(this);
                this.tlsOutputStream = new TlsOutputStream(this);
            }
            if (this.sessionParameters == null) {
                this.sessionMasterSecret = securityParameters.getMasterSecret();
                this.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setExtendedMasterSecret(securityParameters.isExtendedMasterSecret()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(abstractTlsContext.getCrypto().adoptSecret(this.sessionMasterSecret)).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(this.serverExtensions).build();
                this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), this.sessionParameters);
            } else {
                securityParameters.localCertificate = this.sessionParameters.getLocalCertificate();
                securityParameters.peerCertificate = this.sessionParameters.getPeerCertificate();
                securityParameters.pskIdentity = this.sessionParameters.getPSKIdentity();
                securityParameters.srpIdentity = this.sessionParameters.getSRPIdentity();
            }
            abstractTlsContext.handshakeComplete(this.getPeer(), this.tlsSession);
        }
        finally {
            this.cleanupHandshake();
        }
    }

    protected void processRecord(short s, byte[] byArray, int n, int n2) throws IOException {
        switch (s) {
            case 21: {
                this.alertQueue.addData(byArray, n, n2);
                this.processAlertQueue();
                break;
            }
            case 23: {
                if (!this.appDataReady) {
                    throw new TlsFatalAlert(10);
                }
                this.applicationDataQueue.addData(byArray, n, n2);
                break;
            }
            case 20: {
                this.processChangeCipherSpec(byArray, n, n2);
                break;
            }
            case 22: {
                if (this.handshakeQueue.available() > 0) {
                    this.handshakeQueue.addData(byArray, n, n2);
                    this.processHandshakeQueue(this.handshakeQueue);
                    break;
                }
                ByteQueue byteQueue = new ByteQueue(byArray, n, n2);
                this.processHandshakeQueue(byteQueue);
                int n3 = byteQueue.available();
                if (n3 <= 0) break;
                this.handshakeQueue.addData(byArray, n + n2 - n3, n3);
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    private void processHandshakeQueue(ByteQueue byteQueue) throws IOException {
        while (byteQueue.available() >= 4) {
            Object object;
            int n = byteQueue.readInt32();
            short s = (short)(n >>> 24);
            if (!HandshakeType.isRecognized(s)) {
                throw new TlsFatalAlert(10, "Handshake message of unrecognized type: " + s);
            }
            int n2 = n & 0xFFFFFF;
            if (n2 > this.maxHandshakeMessageSize) {
                throw new TlsFatalAlert(80, "Handshake message length exceeds the maximum: " + HandshakeType.getText(s) + ", " + n2 + " > " + this.maxHandshakeMessageSize);
            }
            int n3 = 4 + n2;
            if (byteQueue.available() < n3) break;
            switch (s) {
                case 0: {
                    break;
                }
                default: {
                    object = this.getContext().getServerVersion();
                    if (null != object && TlsUtils.isTLSv13((ProtocolVersion)object)) break;
                    this.checkReceivedChangeCipherSpec(20 == s);
                    break;
                }
            }
            object = byteQueue.readHandshakeMessage(n3);
            switch (s) {
                case 0: 
                case 24: {
                    break;
                }
                case 4: {
                    ProtocolVersion protocolVersion = this.getContext().getServerVersion();
                    if (null == protocolVersion || TlsUtils.isTLSv13(protocolVersion)) break;
                    ((HandshakeMessageInput)object).updateHash(this.handshakeHash);
                    break;
                }
                case 1: 
                case 2: 
                case 15: 
                case 20: {
                    break;
                }
                default: {
                    ((HandshakeMessageInput)object).updateHash(this.handshakeHash);
                }
            }
            ((ByteArrayInputStream)object).skip(4L);
            this.handleHandshakeMessage(s, (HandshakeMessageInput)object);
        }
    }

    private void processAlertQueue() throws IOException {
        while (this.alertQueue.available() >= 2) {
            byte[] byArray = this.alertQueue.removeData(2, 0);
            short s = byArray[0];
            short s2 = byArray[1];
            this.handleAlertMessage(s, s2);
        }
    }

    private void processChangeCipherSpec(byte[] byArray, int n, int n2) throws IOException {
        ProtocolVersion protocolVersion = this.getContext().getServerVersion();
        if (null == protocolVersion || TlsUtils.isTLSv13(protocolVersion)) {
            throw new TlsFatalAlert(10);
        }
        for (int i = 0; i < n2; ++i) {
            short s = TlsUtils.readUint8(byArray, n + i);
            if (s != 1) {
                throw new TlsFatalAlert(50);
            }
            if (this.receivedChangeCipherSpec || this.alertQueue.available() > 0 || this.handshakeQueue.available() > 0) {
                throw new TlsFatalAlert(10);
            }
            this.recordStream.notifyChangeCipherSpecReceived();
            this.receivedChangeCipherSpec = true;
            this.handleChangeCipherSpecMessage();
        }
    }

    public int applicationDataAvailable() {
        return this.applicationDataQueue.available();
    }

    public int readApplicationData(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        int n3 = byArray.length - n;
        int n4 = n3 - n2;
        if ((n | n2 | n3 | n4) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.appDataReady) {
            throw new IllegalStateException("Cannot read application data until initial handshake completed.");
        }
        if (n2 < 1) {
            return 0;
        }
        while (this.applicationDataQueue.available() < 1) {
            if (this.closed) {
                if (this.failed) {
                    throw new IOException("Cannot read application data on failed TLS connection");
                }
                return -1;
            }
            this.safeReadRecord();
        }
        n2 = Math.min(n2, this.applicationDataQueue.available());
        this.applicationDataQueue.removeData(byArray, n, n2, 0);
        return n2;
    }

    protected RecordPreview safePreviewRecordHeader(byte[] byArray) throws IOException {
        try {
            return this.recordStream.previewRecordHeader(byArray);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to read record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to read record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to read record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    protected void safeReadRecord() throws IOException {
        try {
            if (this.recordStream.readRecord()) {
                return;
            }
            if (!this.appDataReady) {
                throw new TlsFatalAlert(40);
            }
            if (!this.getPeer().requiresCloseNotify()) {
                this.handleClose(false);
                return;
            }
        }
        catch (TlsFatalAlertReceived tlsFatalAlertReceived) {
            throw tlsFatalAlertReceived;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to read record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to read record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to read record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        this.handleFailure();
        throw new TlsNoCloseNotifyException();
    }

    protected boolean safeReadFullRecord(byte[] byArray, int n, int n2) throws IOException {
        try {
            return this.recordStream.readFullRecord(byArray, n, n2);
        }
        catch (TlsFatalAlertReceived tlsFatalAlertReceived) {
            throw tlsFatalAlertReceived;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to process record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to process record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to process record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    protected void safeWriteRecord(short s, byte[] byArray, int n, int n2) throws IOException {
        try {
            this.recordStream.writeRecord(s, byArray, n, n2);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to write record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to write record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to write record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeApplicationData(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        int n3 = byArray.length - n;
        int n4 = n3 - n2;
        if ((n | n2 | n3 | n4) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.appDataReady) {
            throw new IllegalStateException("Cannot write application data until initial handshake completed.");
        }
        Object object = this.recordWriteLock;
        synchronized (object) {
            while (n2 > 0) {
                if (this.closed) {
                    throw new IOException("Cannot write application data on closed/failed TLS connection");
                }
                if (this.appDataSplitEnabled) {
                    switch (this.appDataSplitMode) {
                        case 2: {
                            this.appDataSplitEnabled = false;
                        }
                        case 1: {
                            this.safeWriteRecord((short)23, TlsUtils.EMPTY_BYTES, 0, 0);
                            break;
                        }
                        default: {
                            if (n2 > 1) {
                                this.safeWriteRecord((short)23, byArray, n, 1);
                                ++n;
                                --n2;
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                } else if (this.keyUpdateEnabled) {
                    if (this.keyUpdatePendingSend) {
                        this.send13KeyUpdate(false);
                    } else if (this.recordStream.needsKeyUpdate()) {
                        this.send13KeyUpdate(true);
                    }
                }
                n4 = Math.min(n2, this.recordStream.getPlaintextLimit());
                this.safeWriteRecord((short)23, byArray, n, n4);
                n += n4;
                n2 -= n4;
            }
        }
    }

    public int getAppDataSplitMode() {
        return this.appDataSplitMode;
    }

    public void setAppDataSplitMode(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Illegal appDataSplitMode mode: " + n);
        }
        this.appDataSplitMode = n;
    }

    public boolean isResumableHandshake() {
        return this.resumableHandshake;
    }

    public void setResumableHandshake(boolean bl) {
        this.resumableHandshake = bl;
    }

    void writeHandshakeMessage(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 4) {
            throw new TlsFatalAlert(80);
        }
        short s = TlsUtils.readUint8(byArray, n);
        switch (s) {
            case 0: 
            case 24: {
                break;
            }
            case 4: {
                ProtocolVersion protocolVersion = this.getContext().getServerVersion();
                if (null == protocolVersion || TlsUtils.isTLSv13(protocolVersion)) break;
                this.handshakeHash.update(byArray, n, n2);
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.handshakeHash.update(byArray, n, n2);
            }
        }
        int n4 = 0;
        do {
            n3 = Math.min(n2 - n4, this.recordStream.getPlaintextLimit());
            this.safeWriteRecord((short)22, byArray, n + n4, n3);
        } while ((n4 += n3) < n2);
    }

    public OutputStream getOutputStream() {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use OutputStream in non-blocking mode! Use offerOutput() instead.");
        }
        return this.tlsOutputStream;
    }

    public InputStream getInputStream() {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use InputStream in non-blocking mode! Use offerInput() instead.");
        }
        return this.tlsInputStream;
    }

    public void closeInput() throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use closeInput() in blocking mode!");
        }
        if (this.closed) {
            return;
        }
        if (this.inputBuffers.available() > 0) {
            throw new EOFException();
        }
        if (!this.appDataReady) {
            throw new TlsFatalAlert(40);
        }
        if (!this.getPeer().requiresCloseNotify()) {
            this.handleClose(false);
            return;
        }
        this.handleFailure();
        throw new TlsNoCloseNotifyException();
    }

    public RecordPreview previewInputRecord(byte[] byArray) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use previewInputRecord() in blocking mode!");
        }
        if (this.inputBuffers.available() != 0) {
            throw new IllegalStateException("Can only use previewInputRecord() for record-aligned input.");
        }
        if (this.closed) {
            throw new IOException("Connection is closed, cannot accept any more input");
        }
        return this.safePreviewRecordHeader(byArray);
    }

    public int previewOutputRecord() {
        int n;
        int n2;
        if (this.blocking) {
            throw new IllegalStateException("Cannot use previewOutputRecord() in blocking mode!");
        }
        ByteQueue byteQueue = this.outputBuffer.getBuffer();
        int n3 = byteQueue.available();
        if (n3 < 1) {
            return 0;
        }
        if (n3 >= 5 && n3 >= (n2 = 5 + (n = byteQueue.readUint16(3)))) {
            return n2;
        }
        throw new IllegalStateException("Can only use previewOutputRecord() for record-aligned output.");
    }

    public RecordPreview previewOutputRecord(int n) throws IOException {
        if (!this.appDataReady) {
            throw new IllegalStateException("Cannot use previewOutputRecord() until initial handshake completed.");
        }
        if (this.blocking) {
            throw new IllegalStateException("Cannot use previewOutputRecord() in blocking mode!");
        }
        if (this.outputBuffer.getBuffer().available() != 0) {
            throw new IllegalStateException("Can only use previewOutputRecord() for record-aligned output.");
        }
        if (this.closed) {
            throw new IOException("Connection is closed, cannot produce any more output");
        }
        if (n < 1) {
            return new RecordPreview(0, 0);
        }
        if (this.appDataSplitEnabled) {
            switch (this.appDataSplitMode) {
                case 1: 
                case 2: {
                    RecordPreview recordPreview = this.recordStream.previewOutputRecord(0);
                    RecordPreview recordPreview2 = this.recordStream.previewOutputRecord(n);
                    return RecordPreview.combineAppData(recordPreview, recordPreview2);
                }
            }
            RecordPreview recordPreview = this.recordStream.previewOutputRecord(1);
            if (n > 1) {
                RecordPreview recordPreview3 = this.recordStream.previewOutputRecord(n - 1);
                recordPreview = RecordPreview.combineAppData(recordPreview, recordPreview3);
            }
            return recordPreview;
        }
        RecordPreview recordPreview = this.recordStream.previewOutputRecord(n);
        if (this.keyUpdateEnabled && (this.keyUpdatePendingSend || this.recordStream.needsKeyUpdate())) {
            int n2 = HandshakeMessageOutput.getLength(1);
            int n3 = this.recordStream.previewOutputRecordSize(n2);
            recordPreview = RecordPreview.extendRecordSize(recordPreview, n3);
        }
        return recordPreview;
    }

    public void offerInput(byte[] byArray) throws IOException {
        this.offerInput(byArray, 0, byArray.length);
    }

    public void offerInput(byte[] byArray, int n, int n2) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use offerInput() in blocking mode! Use getInputStream() instead.");
        }
        if (this.closed) {
            throw new IOException("Connection is closed, cannot accept any more input");
        }
        if (this.inputBuffers.available() == 0 && this.safeReadFullRecord(byArray, n, n2)) {
            if (this.closed && !this.appDataReady) {
                throw new TlsFatalAlert(80);
            }
            return;
        }
        this.inputBuffers.addBytes(byArray, n, n2);
        while (this.inputBuffers.available() >= 5) {
            byte[] byArray2 = new byte[5];
            if (5 != this.inputBuffers.peek(byArray2)) {
                throw new TlsFatalAlert(80);
            }
            RecordPreview recordPreview = this.safePreviewRecordHeader(byArray2);
            if (this.inputBuffers.available() < recordPreview.getRecordSize()) break;
            this.safeReadRecord();
            if (!this.closed) continue;
            if (this.appDataReady) break;
            throw new TlsFatalAlert(80);
        }
    }

    public int getApplicationDataLimit() {
        return this.recordStream.getPlaintextLimit();
    }

    public int getAvailableInputBytes() {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use getAvailableInputBytes() in blocking mode! Use getInputStream().available() instead.");
        }
        return this.applicationDataAvailable();
    }

    public int readInput(byte[] byArray, int n, int n2) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readInput() in blocking mode! Use getInputStream() instead.");
        }
        if ((n2 = Math.min(n2, this.applicationDataQueue.available())) < 1) {
            return 0;
        }
        this.applicationDataQueue.removeData(byArray, n, n2, 0);
        return n2;
    }

    public int readInput(ByteBuffer byteBuffer, int n) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readInput() in blocking mode! Use getInputStream() instead.");
        }
        if ((n = Math.min(n, this.applicationDataQueue.available())) < 1) {
            return 0;
        }
        this.applicationDataQueue.removeData(byteBuffer, n, 0);
        return n;
    }

    public int getAvailableOutputBytes() {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use getAvailableOutputBytes() in blocking mode! Use getOutputStream() instead.");
        }
        return this.outputBuffer.getBuffer().available();
    }

    public int readOutput(byte[] byArray, int n, int n2) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readOutput() in blocking mode! Use getOutputStream() instead.");
        }
        int n3 = Math.min(this.getAvailableOutputBytes(), n2);
        this.outputBuffer.getBuffer().removeData(byArray, n, n3, 0);
        return n3;
    }

    public int readOutput(ByteBuffer byteBuffer, int n) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readOutput() in blocking mode! Use getOutputStream() instead.");
        }
        int n2 = Math.min(this.getAvailableOutputBytes(), n);
        this.outputBuffer.getBuffer().removeData(byteBuffer, n2, 0);
        return n2;
    }

    protected boolean establishSession(TlsSession tlsSession) {
        this.tlsSession = null;
        this.sessionParameters = null;
        this.sessionMasterSecret = null;
        if (null == tlsSession || !tlsSession.isResumable()) {
            return false;
        }
        SessionParameters sessionParameters = tlsSession.exportSessionParameters();
        if (null == sessionParameters) {
            return false;
        }
        ProtocolVersion protocolVersion = sessionParameters.getNegotiatedVersion();
        if (null == protocolVersion || !protocolVersion.isTLS()) {
            return false;
        }
        if (!TlsUtils.isExtendedMasterSecretOptional(protocolVersion) && sessionParameters.isExtendedMasterSecret() == protocolVersion.isSSL()) {
            return false;
        }
        TlsCrypto tlsCrypto = this.getContext().getCrypto();
        TlsSecret tlsSecret = TlsUtils.getSessionMasterSecret(tlsCrypto, sessionParameters.getMasterSecret());
        if (null == tlsSecret) {
            return false;
        }
        this.tlsSession = tlsSession;
        this.sessionParameters = sessionParameters;
        this.sessionMasterSecret = tlsSecret;
        return true;
    }

    protected void cancelSession() {
        if (this.sessionMasterSecret != null) {
            this.sessionMasterSecret.destroy();
            this.sessionMasterSecret = null;
        }
        if (this.sessionParameters != null) {
            this.sessionParameters.clear();
            this.sessionParameters = null;
        }
        this.tlsSession = null;
    }

    protected void invalidateSession() {
        if (this.tlsSession != null) {
            this.tlsSession.invalidate();
        }
        this.cancelSession();
    }

    protected void processFinishedMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        TlsContext tlsContext = this.getContext();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        boolean bl = tlsContext.isServer();
        byte[] byArray = TlsUtils.readFully(securityParameters.getVerifyDataLength(), (InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        byte[] byArray2 = TlsUtils.calculateVerifyData(tlsContext, this.handshakeHash, !bl);
        if (!Arrays.constantTimeAreEqual((byte[])byArray2, (byte[])byArray)) {
            throw new TlsFatalAlert(51);
        }
        securityParameters.peerVerifyData = byArray2;
        if ((!securityParameters.isResumedSession() || securityParameters.isExtendedMasterSecret()) && null == securityParameters.getLocalVerifyData()) {
            securityParameters.tlsUnique = byArray2;
        }
    }

    protected void process13FinishedMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        TlsContext tlsContext = this.getContext();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        boolean bl = tlsContext.isServer();
        byte[] byArray = TlsUtils.readFully(securityParameters.getVerifyDataLength(), (InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        byte[] byArray2 = TlsUtils.calculateVerifyData(tlsContext, this.handshakeHash, !bl);
        if (!Arrays.constantTimeAreEqual((byte[])byArray2, (byte[])byArray)) {
            throw new TlsFatalAlert(51);
        }
        securityParameters.peerVerifyData = byArray2;
        securityParameters.tlsUnique = null;
    }

    protected void raiseAlertFatal(short s, String string, Throwable throwable) throws IOException {
        this.getPeer().notifyAlertRaised((short)2, s, string, throwable);
        byte[] byArray = new byte[]{2, (byte)s};
        try {
            this.recordStream.writeRecord((short)21, byArray, 0, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void raiseAlertWarning(short s, String string) throws IOException {
        this.getPeer().notifyAlertRaised((short)1, s, string, null);
        byte[] byArray = new byte[]{1, (byte)s};
        this.safeWriteRecord((short)21, byArray, 0, 2);
    }

    protected void receive13KeyUpdate(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (!this.appDataReady || !this.keyUpdateEnabled) {
            throw new TlsFatalAlert(10);
        }
        short s = TlsUtils.readUint8(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!KeyUpdateRequest.isValid(s)) {
            throw new TlsFatalAlert(47);
        }
        boolean bl = 1 == s;
        TlsUtils.update13TrafficSecretPeer(this.getContext());
        this.recordStream.notifyKeyUpdateReceived();
        this.keyUpdatePendingSend |= bl;
    }

    protected void sendCertificateMessage(Certificate certificate, OutputStream outputStream) throws IOException {
        TlsContext tlsContext = this.getContext();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        if (null != securityParameters.getLocalCertificate()) {
            throw new TlsFatalAlert(80);
        }
        if (null == certificate) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        if (certificate.isEmpty() && !tlsContext.isServer() && securityParameters.getNegotiatedVersion().isSSL()) {
            String string = "SSLv3 client didn't provide credentials";
            this.raiseAlertWarning((short)41, string);
        } else {
            HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(11);
            certificate.encode(tlsContext, handshakeMessageOutput, outputStream);
            handshakeMessageOutput.send(this);
        }
        securityParameters.localCertificate = certificate;
    }

    protected void send13CertificateMessage(Certificate certificate) throws IOException {
        if (null == certificate) {
            throw new TlsFatalAlert(80);
        }
        TlsContext tlsContext = this.getContext();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        if (null != securityParameters.getLocalCertificate()) {
            throw new TlsFatalAlert(80);
        }
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(11);
        certificate.encode(tlsContext, handshakeMessageOutput, null);
        handshakeMessageOutput.send(this);
        securityParameters.localCertificate = certificate;
    }

    protected void send13CertificateVerifyMessage(DigitallySigned digitallySigned) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(15);
        digitallySigned.encode(handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendChangeCipherSpec() throws IOException {
        this.sendChangeCipherSpecMessage();
        this.recordStream.enablePendingCipherWrite();
    }

    protected void sendChangeCipherSpecMessage() throws IOException {
        byte[] byArray = new byte[]{1};
        this.safeWriteRecord((short)20, byArray, 0, byArray.length);
    }

    protected void sendFinishedMessage() throws IOException {
        TlsContext tlsContext = this.getContext();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        boolean bl = tlsContext.isServer();
        byte[] byArray = TlsUtils.calculateVerifyData(tlsContext, this.handshakeHash, bl);
        securityParameters.localVerifyData = byArray;
        if ((!securityParameters.isResumedSession() || securityParameters.isExtendedMasterSecret()) && null == securityParameters.getPeerVerifyData()) {
            securityParameters.tlsUnique = byArray;
        }
        HandshakeMessageOutput.send(this, (short)20, byArray);
    }

    protected void send13FinishedMessage() throws IOException {
        TlsContext tlsContext = this.getContext();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        boolean bl = tlsContext.isServer();
        byte[] byArray = TlsUtils.calculateVerifyData(tlsContext, this.handshakeHash, bl);
        securityParameters.localVerifyData = byArray;
        securityParameters.tlsUnique = null;
        HandshakeMessageOutput.send(this, (short)20, byArray);
    }

    protected void send13KeyUpdate(boolean bl) throws IOException {
        if (!this.appDataReady || !this.keyUpdateEnabled) {
            throw new TlsFatalAlert(80);
        }
        short s = bl ? (short)1 : 0;
        HandshakeMessageOutput.send(this, (short)24, TlsUtils.encodeUint8(s));
        TlsUtils.update13TrafficSecretLocal(this.getContext());
        this.recordStream.notifyKeyUpdateSent();
        this.keyUpdatePendingSend &= bl;
    }

    protected void sendSupplementalDataMessage(Vector vector) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(23);
        TlsProtocol.writeSupplementalData(handshakeMessageOutput, vector);
        handshakeMessageOutput.send(this);
    }

    @Override
    public void close() throws IOException {
        this.handleClose(true);
    }

    public void flush() throws IOException {
    }

    boolean isApplicationDataReady() {
        return this.appDataReady;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isConnected() {
        if (this.closed) {
            return false;
        }
        AbstractTlsContext abstractTlsContext = this.getContextAdmin();
        return null != abstractTlsContext && abstractTlsContext.isConnected();
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isHandshaking() {
        if (this.closed) {
            return false;
        }
        AbstractTlsContext abstractTlsContext = this.getContextAdmin();
        return null != abstractTlsContext && abstractTlsContext.isHandshaking();
    }

    @Deprecated
    protected short processMaxFragmentLengthExtension(Hashtable hashtable, Hashtable hashtable2, short s) throws IOException {
        return TlsUtils.processMaxFragmentLengthExtension(hashtable, hashtable2, s);
    }

    protected void refuseRenegotiation() throws IOException {
        if (TlsUtils.isSSL(this.getContext())) {
            throw new TlsFatalAlert(40);
        }
        this.raiseAlertWarning((short)100, "Renegotiation not supported");
    }

    protected static void assertEmpty(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (byteArrayInputStream.available() > 0) {
            throw new TlsFatalAlert(50);
        }
    }

    protected static byte[] createRandomBlock(boolean bl, TlsContext tlsContext) {
        byte[] byArray = tlsContext.getNonceGenerator().generateNonce(32);
        if (bl) {
            TlsUtils.writeGMTUnixTime(byArray, 0);
        }
        return byArray;
    }

    protected static byte[] createRenegotiationInfo(byte[] byArray) throws IOException {
        return TlsUtils.encodeOpaque8(byArray);
    }

    protected static void establishMasterSecret(TlsContext tlsContext, TlsKeyExchange tlsKeyExchange) throws IOException {
        TlsSecret tlsSecret = tlsKeyExchange.generatePreMasterSecret();
        if (tlsSecret == null) {
            throw new TlsFatalAlert(80);
        }
        try {
            tlsContext.getSecurityParametersHandshake().masterSecret = TlsUtils.calculateMasterSecret(tlsContext, tlsSecret);
        }
        finally {
            tlsSecret.destroy();
        }
    }

    protected static Hashtable readExtensions(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (byteArrayInputStream.available() < 1) {
            return null;
        }
        byte[] byArray = TlsUtils.readOpaque16(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return TlsProtocol.readExtensionsData(byArray);
    }

    protected static Hashtable readExtensionsData(byte[] byArray) throws IOException {
        Hashtable<Integer, byte[]> hashtable = new Hashtable<Integer, byte[]>();
        if (byArray.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            do {
                int n = TlsUtils.readUint16(byteArrayInputStream);
                byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream);
                if (null == hashtable.put(Integers.valueOf((int)n), byArray2)) continue;
                throw new TlsFatalAlert(47, "Repeated extension: " + ExtensionType.getText(n));
            } while (byteArrayInputStream.available() > 0);
        }
        return hashtable;
    }

    protected static Hashtable readExtensionsData13(int n, byte[] byArray) throws IOException {
        Hashtable<Integer, byte[]> hashtable = new Hashtable<Integer, byte[]>();
        if (byArray.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            do {
                int n2;
                if (!TlsUtils.isPermittedExtensionType13(n, n2 = TlsUtils.readUint16(byteArrayInputStream))) {
                    throw new TlsFatalAlert(47, "Invalid extension: " + ExtensionType.getText(n2));
                }
                byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream);
                if (null == hashtable.put(Integers.valueOf((int)n2), byArray2)) continue;
                throw new TlsFatalAlert(47, "Repeated extension: " + ExtensionType.getText(n2));
            } while (byteArrayInputStream.available() > 0);
        }
        return hashtable;
    }

    protected static Hashtable readExtensionsDataClientHello(byte[] byArray) throws IOException {
        Hashtable<Integer, byte[]> hashtable = new Hashtable<Integer, byte[]>();
        if (byArray.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            int n = -1;
            boolean bl = false;
            do {
                n = TlsUtils.readUint16(byteArrayInputStream);
                byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream);
                if (null != hashtable.put(Integers.valueOf((int)n), byArray2)) {
                    throw new TlsFatalAlert(47, "Repeated extension: " + ExtensionType.getText(n));
                }
                bl |= 41 == n;
            } while (byteArrayInputStream.available() > 0);
            if (bl && 41 != n) {
                throw new TlsFatalAlert(47, "'pre_shared_key' MUST be last in ClientHello");
            }
        }
        return hashtable;
    }

    protected static Vector readSupplementalDataMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque24(byteArrayInputStream, 1);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
        Vector<SupplementalDataEntry> vector = new Vector<SupplementalDataEntry>();
        while (byteArrayInputStream2.available() > 0) {
            int n = TlsUtils.readUint16(byteArrayInputStream2);
            byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream2);
            vector.addElement(new SupplementalDataEntry(n, byArray2));
        }
        return vector;
    }

    protected static void writeExtensions(OutputStream outputStream, Hashtable hashtable) throws IOException {
        TlsProtocol.writeExtensions(outputStream, hashtable, 0);
    }

    protected static void writeExtensions(OutputStream outputStream, Hashtable hashtable, int n) throws IOException {
        if (null == hashtable || hashtable.isEmpty()) {
            return;
        }
        byte[] byArray = TlsProtocol.writeExtensionsData(hashtable, n);
        int n2 = byArray.length + n;
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, outputStream);
        outputStream.write(byArray);
    }

    protected static byte[] writeExtensionsData(Hashtable hashtable) throws IOException {
        return TlsProtocol.writeExtensionsData(hashtable, 0);
    }

    protected static byte[] writeExtensionsData(Hashtable hashtable, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsProtocol.writeExtensionsData(hashtable, n, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected static void writeExtensionsData(Hashtable hashtable, int n, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        TlsProtocol.writeSelectedExtensions(byteArrayOutputStream, hashtable, true);
        TlsProtocol.writeSelectedExtensions(byteArrayOutputStream, hashtable, false);
        TlsProtocol.writePreSharedKeyExtension(byteArrayOutputStream, hashtable, n);
    }

    protected static void writePreSharedKeyExtension(OutputStream outputStream, Hashtable hashtable, int n) throws IOException {
        byte[] byArray = (byte[])hashtable.get(TlsExtensionsUtils.EXT_pre_shared_key);
        if (null != byArray) {
            TlsUtils.checkUint16(41);
            TlsUtils.writeUint16(41, outputStream);
            int n2 = byArray.length + n;
            TlsUtils.checkUint16(n2);
            TlsUtils.writeUint16(n2, outputStream);
            outputStream.write(byArray);
        }
    }

    protected static void writeSelectedExtensions(OutputStream outputStream, Hashtable hashtable, boolean bl) throws IOException {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            byte[] byArray;
            Integer n = (Integer)enumeration.nextElement();
            int n2 = n;
            if (41 == n2 || bl != ((byArray = (byte[])hashtable.get(n)).length == 0)) continue;
            TlsUtils.checkUint16(n2);
            TlsUtils.writeUint16(n2, outputStream);
            TlsUtils.writeOpaque16(byArray, outputStream);
        }
    }

    protected static void writeSupplementalData(OutputStream outputStream, Vector vector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < vector.size(); ++i) {
            SupplementalDataEntry supplementalDataEntry = (SupplementalDataEntry)vector.elementAt(i);
            int n = supplementalDataEntry.getDataType();
            TlsUtils.checkUint16(n);
            TlsUtils.writeUint16(n, byteArrayOutputStream);
            TlsUtils.writeOpaque16(supplementalDataEntry.getData(), byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeOpaque24(byArray, outputStream);
    }
}

