/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSASigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSA13Signer;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSASigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsEd25519Signer;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsEd448Signer;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsMLDSASigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAPSSSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSASigner;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner makeSigner(JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        TlsSigner tlsSigner;
        String string = privateKey.getAlgorithm();
        if (privateKey instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(string) || "RSASSA-PSS".equalsIgnoreCase(string)) {
            int n;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isRSAPSS(n = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new JcaTlsRSAPSSSigner(jcaTlsCrypto, privateKey, n);
            }
            tlsSigner = new JcaTlsRSASigner(jcaTlsCrypto, privateKey);
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(string)) {
            tlsSigner = new JcaTlsDSASigner(jcaTlsCrypto, privateKey);
        } else if (ECUtil.isECPrivateKey(privateKey)) {
            int n;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isECDSA(n = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new JcaTlsECDSA13Signer(jcaTlsCrypto, privateKey, n);
            }
            tlsSigner = new JcaTlsECDSASigner(jcaTlsCrypto, privateKey);
        } else if ("Ed25519".equalsIgnoreCase(string)) {
            tlsSigner = new JcaTlsEd25519Signer(jcaTlsCrypto, privateKey);
        } else if ("Ed448".equalsIgnoreCase(string)) {
            tlsSigner = new JcaTlsEd448Signer(jcaTlsCrypto, privateKey);
        } else if ("ML-DSA-44".equalsIgnoreCase(string)) {
            tlsSigner = new JcaTlsMLDSASigner(jcaTlsCrypto, privateKey, 2308);
        } else if ("ML-DSA-65".equalsIgnoreCase(string)) {
            tlsSigner = new JcaTlsMLDSASigner(jcaTlsCrypto, privateKey, 2309);
        } else if ("ML-DSA-87".equalsIgnoreCase(string)) {
            tlsSigner = new JcaTlsMLDSASigner(jcaTlsCrypto, privateKey, 2310);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return tlsSigner;
    }

    public JcaDefaultTlsCredentialedSigner(TlsCryptoParameters tlsCryptoParameters, JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(tlsCryptoParameters, JcaDefaultTlsCredentialedSigner.makeSigner(jcaTlsCrypto, privateKey, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

