/*
 * Decompiled with CFR 0.152.
 */
package org.bradfordmiller.simplejndiutils;

import io.vavr.control.Either;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.osjava.sj.jndi.MemoryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNDIUtils {
    private static final Logger logger = LoggerFactory.getLogger(JNDIUtils.class);

    public static MemoryContext getMemoryContextFromInitContext(InitialContext initCtx, String contextName) {
        try {
            MemoryContext mc = (MemoryContext)initCtx.lookup(contextName);
            return mc;
        }
        catch (NamingException ne) {
            logger.error(String.format("Naming exception occurred on jndi lookup of context %s: %s", contextName, ne.getMessage()));
            return null;
        }
    }

    public static Either<DataSource, Map<String, String>> getDataSource(String jndi, String context) {
        try {
            InitialContext ctx = new InitialContext();
            MemoryContext mc = (MemoryContext)ctx.lookup(context);
            Object lookup = mc.lookup(jndi);
            if (lookup instanceof DataSource) {
                return Either.left((Object)((DataSource)lookup));
            }
            if (lookup instanceof Map) {
                return Either.right((Object)((Map)lookup));
            }
            throw new InvalidObjectException(String.format("jndi entry %s for context %s is neither a DataSource or a Map<string, String", jndi, context));
        }
        catch (InvalidObjectException | NamingException ne) {
            logger.error(String.format("Naming exception occurred on jndi lookup of context %s: %s", context, ne.getMessage()));
            return null;
        }
    }

    public static Connection getConnection(DataSource ds) throws SQLException {
        try {
            return ds.getConnection();
        }
        catch (SQLException sqlEx) {
            logger.error(String.format("Error fetching connection from data source: %s", sqlEx.getMessage()));
            throw sqlEx;
        }
    }

    public static Connection getJndiConnection(String jndiString, String context) throws SQLException {
        DataSource ds = (DataSource)JNDIUtils.getDataSource(jndiString, context).getLeft();
        return JNDIUtils.getConnection(ds);
    }

    public static List<String> getAvailableJndiContexts(InitialContext context) throws NamingException, IOException {
        List<String> list;
        block9: {
            if (context == null) {
                context = new InitialContext();
            }
            String root = context.getEnvironment().get("org.osjava.sj.root").toString();
            Stream<Path> pathFiles = Files.walk(Paths.get(root, new String[0]), new FileVisitOption[0]);
            try {
                List<String> files;
                list = files = pathFiles.map(f -> f.toString()).filter(f -> f.endsWith(".properties")).collect(Collectors.toList());
                if (pathFiles == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pathFiles != null) {
                        try {
                            pathFiles.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioex) {
                    logger.error(String.format("Error accessing available jndi contexts: %s", ioex.getMessage()));
                    throw ioex;
                }
            }
            pathFiles.close();
        }
        return list;
    }

    public static Map<String, String> getEntriesForJndiContext(MemoryContext memoryContext) throws NoSuchFieldException, IllegalAccessException {
        Field field = memoryContext.getClass().getDeclaredField("namesToObjects");
        field.setAccessible(true);
        Map fieldMap = (Map)field.get(memoryContext);
        Map<String, String> map = fieldMap.entrySet().stream().collect(Collectors.toMap(k -> String.valueOf(((Name)k.getKey()).toString()), v -> String.valueOf(v.getValue())));
        return map;
    }

    public static Map.Entry<String, String> getDetailsforJndiEntry(InitialContext context, String jndiName, String entry) throws NoSuchFieldException, IllegalAccessException {
        MemoryContext mc = JNDIUtils.getMemoryContextFromInitContext(context, jndiName);
        Map<String, String> entries = JNDIUtils.getEntriesForJndiContext(mc);
        return new AbstractMap.SimpleEntry<String, String>(entry, entries.get(entry));
    }

    public static Boolean addJndiConnection(String jndiName, String context, Map<String, String> values) throws NamingException, IOException, IllegalAccessException, NoSuchFieldException {
        BiConsumer<File, String> writeToFile = (backupFile, delimiter) -> {
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(backupFile.getAbsolutePath(), true));){
                bw.write("\n");
                values.forEach((k, v) -> {
                    try {
                        bw.write(String.format("%s%s%s=%s\n", jndiName, delimiter, k, v));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (IOException ioex) {
                logger.error(String.format("Error adding jndi connection: %s", ioex.getMessage()));
                throw new RuntimeException(ioex);
            }
        };
        InitialContext ctx = new InitialContext();
        String root = ctx.getEnvironment().get("org.osjava.sj.root").toString();
        String colonReplace = ctx.getEnvironment().get("org.osjava.sj.colon.replace").toString();
        String delimiter2 = ctx.getEnvironment().get("org.osjava.sj.delimiter").toString();
        File file = new File(String.format("%s/%s.properties", root, context));
        File lockFile = new File(String.format("%s/.LOCK", root));
        try {
            if (lockFile.exists()) {
                logger.info("jndi director is currently being modified. Please try to add your new entry later.");
                Boolean bl = false;
                return bl;
            }
            logger.info("Lock file is absent. Locking directory before proceeding");
            lockFile.createNewFile();
            MemoryContext memoryContext = JNDIUtils.getMemoryContextFromInitContext(ctx, context);
            if (memoryContext != null) {
                Map<String, String> fieldKeys = JNDIUtils.getEntriesForJndiContext(memoryContext);
                if (fieldKeys.containsKey(jndiName)) {
                    String errorString = String.format("Jndi name %s already exists for context %s.", jndiName, context);
                    logger.error(errorString);
                    throw new IllegalAccessException(errorString);
                }
                String uuid = UUID.randomUUID().toString();
                File backupFile2 = new File(file.getParentFile().getName() + "/" + context + "_" + uuid + ".properties");
                FileUtils.copyFile((File)file, (File)backupFile2);
                writeToFile.accept(backupFile2, delimiter2);
                backupFile2.renameTo(file);
                Boolean bl = true;
                return bl;
            }
            File f = new File(String.format("%s/%s.properties", root, context));
            writeToFile.accept(f, delimiter2);
            Boolean bl = true;
            return bl;
        }
        catch (IllegalAccessException iaex) {
            logger.error(String.format("Illegal access exception while adding jndi connection: %s", iaex.getMessage()));
            throw iaex;
        }
        catch (NoSuchFieldException nsfex) {
            logger.error(String.format("No such field exception hit while adding jndi connection: %s", nsfex.getMessage()));
            throw nsfex;
        }
        finally {
            logger.info("Deleting lock file. Directory is writable.");
            lockFile.delete();
        }
    }
}

