/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache;

import java.io.Serializable;
import org.brandao.brcache.Configuration;
import org.brandao.brcache.collections.DiskSwapper;
import org.brandao.brcache.collections.Swapper;
import org.brandao.brcache.memory.Memory;

public class BRCacheConfig
implements Serializable {
    private static final long serialVersionUID = 9065603898804344980L;
    private static final String SWAPPER_PREFIX = "org.brandao.brcache.collections.swapper.";
    private static final String SWAPPER_SUFFIX = "Swapper";
    private static final String MEMORY_PREFIX = "org.brandao.brcache.memory.";
    private static final String MEMORY_SUFFIX = "Memory";
    protected long nodesBufferSize;
    protected long nodesPageSize;
    protected double nodesSwapFactor;
    protected long indexBufferSize;
    protected long indexPageSize;
    protected double indexSwapFactor;
    protected long dataBufferSize;
    protected long dataBlockSize;
    protected long dataPageSize;
    protected double dataSwapFactor;
    protected long maxSizeEntry;
    protected int maxSizeKey;
    protected int swapperThread;
    protected Swapper swapper;
    protected Memory memory;
    protected String dataPath;
    protected Configuration configuration;

    public BRCacheConfig() {
    }

    public BRCacheConfig(Configuration config) {
        this.setConfiguration(config);
    }

    public void setConfiguration(Configuration config) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.configuration = config;
        this.nodesBufferSize = config.getLong("nodes_buffer_size", "1m");
        this.nodesPageSize = config.getLong("nodes_page_size", "1k");
        this.nodesSwapFactor = config.getDouble("nodes_swap_factor", "0.3");
        this.indexBufferSize = config.getLong("index_buffer_size", "1m");
        this.indexPageSize = config.getLong("index_page_size", "1k");
        this.indexSwapFactor = config.getDouble("index_swap_factor", "0.3");
        this.dataBufferSize = config.getLong("data_buffer_size", "64m");
        this.dataBlockSize = config.getLong("data_block_size", "1k");
        this.dataPageSize = config.getLong("data_page_size", "8k");
        this.dataSwapFactor = config.getDouble("data_swap_factor", "0.3");
        this.maxSizeEntry = config.getLong("max_size_entry", "1m");
        this.maxSizeKey = config.getInt("max_size_key", "100");
        this.swapperThread = config.getInt("swapper_thread", "4");
        this.dataPath = config.getString("data_path", "/mnt/brcache");
        this.swapper = this.createSwapper(config.getString("swapper_type", "file"), classLoader);
        this.memory = this.createMemory(config.getString("memory_access_type", "heap"), classLoader);
        if (this.swapper instanceof DiskSwapper) {
            ((DiskSwapper)this.swapper).setRootPath(this.dataPath);
        }
    }

    protected Swapper createSwapper(String name, ClassLoader classLoader) {
        try {
            String className = SWAPPER_PREFIX + Character.toUpperCase(name.charAt(0)) + name.substring(1, name.length()).toLowerCase() + SWAPPER_SUFFIX;
            Class<?> clazz = Class.forName(className, true, classLoader);
            return (Swapper)clazz.newInstance();
        }
        catch (Throwable e) {
            throw new IllegalStateException("invalid swapper type: " + name, e);
        }
    }

    protected Memory createMemory(String name, ClassLoader classLoader) {
        try {
            String className = MEMORY_PREFIX + Character.toUpperCase(name.charAt(0)) + name.substring(1, name.length()).toLowerCase() + MEMORY_SUFFIX;
            Class<?> clazz = Class.forName(className, true, classLoader);
            return (Memory)clazz.newInstance();
        }
        catch (Throwable e) {
            throw new IllegalStateException("invalid memory type: " + name, e);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public long getNodesBufferSize() {
        return this.nodesBufferSize;
    }

    public void setNodesBufferSize(long nodesBufferSize) {
        this.nodesBufferSize = nodesBufferSize;
    }

    public long getNodesPageSize() {
        return this.nodesPageSize;
    }

    public void setNodesPageSize(long nodesPageSize) {
        this.nodesPageSize = nodesPageSize;
    }

    public double getNodesSwapFactor() {
        return this.nodesSwapFactor;
    }

    public void setNodesSwapFactor(double nodesSwapFactor) {
        this.nodesSwapFactor = nodesSwapFactor;
    }

    public long getIndexBufferSize() {
        return this.indexBufferSize;
    }

    public void setIndexBufferSize(long indexBufferSize) {
        this.indexBufferSize = indexBufferSize;
    }

    public long getIndexPageSize() {
        return this.indexPageSize;
    }

    public void setIndexPageSize(long indexPageSize) {
        this.indexPageSize = indexPageSize;
    }

    public double getIndexSwapFactor() {
        return this.indexSwapFactor;
    }

    public void setIndexSwapFactor(double indexSwapFactor) {
        this.indexSwapFactor = indexSwapFactor;
    }

    public long getDataBufferSize() {
        return this.dataBufferSize;
    }

    public void setDataBufferSize(long dataBufferSize) {
        this.dataBufferSize = dataBufferSize;
    }

    public long getDataBlockSize() {
        return this.dataBlockSize;
    }

    public void setDataBlockSize(long dataBlockSize) {
        this.dataBlockSize = dataBlockSize;
    }

    public long getDataPageSize() {
        return this.dataPageSize;
    }

    public void setDataPageSize(long dataPageSize) {
        this.dataPageSize = dataPageSize;
    }

    public double getDataSwapFactor() {
        return this.dataSwapFactor;
    }

    public void setDataSwapFactor(double dataSwapFactor) {
        this.dataSwapFactor = dataSwapFactor;
    }

    public long getMaxSizeEntry() {
        return this.maxSizeEntry;
    }

    public void setMaxSizeEntry(long maxSizeEntry) {
        this.maxSizeEntry = maxSizeEntry;
    }

    public int getMaxSizeKey() {
        return this.maxSizeKey;
    }

    public void setMaxSizeKey(int maxSizeKey) {
        this.maxSizeKey = maxSizeKey;
    }

    public int getSwapperThread() {
        return this.swapperThread;
    }

    public void setSwapperThread(int swapperThread) {
        this.swapperThread = swapperThread;
    }

    public Swapper getSwapper() {
        return this.swapper;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public void setMemory(Memory memory) {
        this.memory = memory;
    }

    public void setSwapper(Swapper swapper) {
        this.swapper = swapper;
    }
}

