/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.brandao.brcache.BRCacheConfig;
import org.brandao.brcache.CacheErrors;
import org.brandao.brcache.Configuration;
import org.brandao.brcache.RecoverException;
import org.brandao.brcache.StorageException;
import org.brandao.brcache.StreamCache;
import org.brandao.brcache.collections.Swapper;
import org.brandao.brcache.memory.Memory;
import org.brandao.brcache.tx.CacheTransactionManager;
import org.brandao.brcache.tx.TXCache;

public class BasicCache
extends StreamCache {
    private static final long serialVersionUID = -3101078990483084845L;
    protected BRCacheConfig config;

    public BasicCache() {
        this(new BRCacheConfig(new Configuration()));
    }

    public BasicCache(BRCacheConfig config) {
        this(config.getNodesBufferSize(), config.getNodesPageSize(), config.getNodesSwapFactor(), config.getIndexBufferSize(), config.getIndexPageSize(), config.getIndexSwapFactor(), config.getDataBufferSize(), config.getDataPageSize(), config.getDataBlockSize(), config.getDataSwapFactor(), config.getMaxSizeEntry(), config.getMaxSizeKey(), config.getSwapper(), config.getSwapperThread(), config.getMemory());
        this.config = config;
    }

    public BasicCache(long nodeBufferSize, long nodePageSize, double nodeSwapFactor, long indexBufferSize, long indexPageSize, double indexSwapFactor, long dataBufferSize, long dataPageSize, long blockSize, double dataSwapFactor, long maxSizeEntry, int maxSizeKey, Swapper swapper, int quantitySwaperThread, Memory memory) {
        super(nodeBufferSize, nodePageSize, nodeSwapFactor, indexBufferSize, indexPageSize, indexSwapFactor, dataBufferSize, dataPageSize, blockSize, dataSwapFactor, maxSizeEntry, maxSizeKey, swapper, quantitySwaperThread, memory);
    }

    public TXCache getTXCache() {
        return new TXCache(this);
    }

    public TXCache getTXCache(CacheTransactionManager txManager) {
        return new TXCache(this, txManager);
    }

    public boolean replace(String key, Object value, long timeToLive, long timeToIdle) throws StorageException {
        ByteArrayOutputStream bout;
        try {
            bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(value);
            oout.flush();
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
        try {
            return super.replaceStream(key, new ByteArrayInputStream(bout.toByteArray()), timeToLive, timeToIdle);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (RecoverException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
    }

    public boolean replaceStream(String key, InputStream inputData, long timeToLive, long timeToIdle) throws StorageException {
        return super.replaceStream(key, inputData, timeToLive, timeToIdle);
    }

    public Object putIfAbsent(String key, Object value, long timeToLive, long timeToIdle) throws StorageException {
        ByteArrayOutputStream bout;
        try {
            bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(value);
            oout.flush();
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
        try {
            InputStream in = super.putIfAbsentStream(key, new ByteArrayInputStream(bout.toByteArray()), timeToLive, timeToIdle);
            if (in != null) {
                ObjectInputStream oin = new ObjectInputStream(in);
                return oin.readObject();
            }
            return null;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
    }

    public InputStream putIfAbsentStream(String key, InputStream inputData, long timeToLive, long timeToIdle) throws StorageException {
        return super.putIfAbsentStream(key, inputData, timeToLive, timeToIdle);
    }

    public boolean put(String key, Object value, long timeToLive, long timeToIdle) throws StorageException {
        ByteArrayOutputStream bout;
        try {
            bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(value);
            oout.flush();
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
        try {
            return this.putStream(key, new ByteArrayInputStream(bout.toByteArray()), timeToLive, timeToIdle);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
    }

    public boolean putStream(String key, InputStream inputData, long timeToLive, long timeToIdle) throws StorageException {
        return super.putStream(key, inputData, timeToLive, timeToIdle);
    }

    public Object get(String key) throws RecoverException {
        try {
            InputStream in = super.getStream(key);
            if (in != null) {
                ObjectInputStream oin = new ObjectInputStream(in);
                return oin.readObject();
            }
            return null;
        }
        catch (RecoverException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1021, new Object[0]);
        }
    }

    public InputStream getStream(String key) throws RecoverException {
        return super.getStream(key);
    }

    public boolean remove(String key) throws StorageException {
        return super.removeStream(key);
    }

    public BRCacheConfig getConfig() {
        return this.config;
    }
}

