/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache;

import java.io.InputStream;
import java.io.Serializable;
import org.brandao.brcache.BRCacheConfig;
import org.brandao.brcache.BasicCache;
import org.brandao.brcache.CacheErrors;
import org.brandao.brcache.Configuration;
import org.brandao.brcache.RecoverException;
import org.brandao.brcache.StorageException;
import org.brandao.concurrent.NamedLock;

public class Cache
extends BasicCache {
    private static final long serialVersionUID = -8558471389768293591L;
    protected transient NamedLock locks = new NamedLock();

    public Cache() {
        super(new BRCacheConfig(new Configuration()));
    }

    public Cache(BRCacheConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(String key, Object value, long timeToLive, long timeToIdle) throws StorageException {
        Serializable refLock = this.locks.lock(key);
        try {
            boolean bl = super.replace(key, value, timeToLive, timeToIdle);
            return bl;
        }
        finally {
            if (refLock != null) {
                this.locks.unlock(refLock, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceStream(String key, InputStream inputData, long timeToLive, long timeToIdle) throws StorageException {
        Serializable refLock = this.locks.lock(key);
        try {
            boolean bl = super.replaceStream(key, inputData, timeToLive, timeToIdle);
            return bl;
        }
        finally {
            if (refLock != null) {
                this.locks.unlock(refLock, key);
            }
        }
    }

    public boolean replace(String key, Object oldValue, Object newValue, long timeToLive, long timeToIdle) throws StorageException {
        Serializable refLock = this.locks.lock(key);
        try {
            Object o = super.get(key);
            if (o != null && o.equals(oldValue)) {
                super.put(key, newValue, timeToLive, timeToIdle);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (RecoverException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        finally {
            if (refLock != null) {
                this.locks.unlock(refLock, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putIfAbsent(String key, Object value, long timeToLive, long timeToIdle) throws StorageException {
        Serializable refLock = this.locks.lock(key);
        try {
            Object object = super.putIfAbsent(key, value, timeToLive, timeToIdle);
            return object;
        }
        finally {
            if (refLock != null) {
                this.locks.unlock(refLock, key);
            }
        }
    }

    public InputStream putIfAbsentStream(String key, InputStream inputData, long timeToLive, long timeToIdle) throws StorageException {
        Serializable refLock = this.locks.lock(key);
        try {
            InputStream inputStream = super.putIfAbsentStream(key, inputData, timeToLive, timeToIdle);
            return inputStream;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (RecoverException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        finally {
            if (refLock != null) {
                this.locks.unlock(refLock, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String key, Object value, long timeToLive, long timeToIdle) throws StorageException {
        Serializable refLock = this.locks.lock(key);
        try {
            boolean bl = super.put(key, value, timeToLive, timeToIdle);
            return bl;
        }
        finally {
            if (refLock != null) {
                this.locks.unlock(refLock, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putStream(String key, InputStream inputData, long timeToLive, long timeToIdle) throws StorageException {
        Serializable refLock = this.locks.lock(key);
        try {
            boolean bl = super.putStream(key, inputData, timeToLive, timeToIdle);
            return bl;
        }
        finally {
            if (refLock != null) {
                this.locks.unlock(refLock, key);
            }
        }
    }

    public Object get(String key) throws RecoverException {
        return super.get(key);
    }

    public InputStream getStream(String key) throws RecoverException {
        return super.getStream(key);
    }

    public boolean remove(String key, Object value) throws StorageException {
        Serializable refLock = this.locks.lock(key);
        try {
            Object o = super.get(key);
            if (o != null && o.equals(value)) {
                boolean bl = super.remove(key);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (RecoverException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1021, new Object[0]);
        }
        finally {
            if (refLock != null) {
                this.locks.unlock(refLock, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String key) throws StorageException {
        Serializable refLock = this.locks.lock(key);
        try {
            boolean bl = super.remove(key);
            return bl;
        }
        finally {
            if (refLock != null) {
                this.locks.unlock(refLock, key);
            }
        }
    }

    public long size() {
        return super.getCountRemoved() - super.getCountWrite();
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public boolean containsKey(String key) throws RecoverException {
        return super.getStream(key) != null;
    }
}

