/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.brandao.brcache.Block;
import org.brandao.brcache.DataMap;
import org.brandao.brcache.StreamCache;
import org.brandao.brcache.memory.RegionMemory;

public class CacheInputStream
extends InputStream {
    private DataMap map;
    private Block[] arrayDataList;
    private int currentSegmentIndex;
    private int currentDataindex;
    private StreamCache cache;
    private byte[] bufByte = new byte[1];

    public CacheInputStream() {
        this(null, null, null);
    }

    public CacheInputStream(StreamCache cache, DataMap map, Block[] dataList) {
        this.map = map;
        this.arrayDataList = dataList;
        this.currentDataindex = 0;
        this.currentSegmentIndex = 0;
        this.cache = cache;
    }

    public DataMap getMap() {
        return this.map;
    }

    public void setMap(DataMap map) {
        this.map = map;
    }

    public Block[] getArrayDataList() {
        return this.arrayDataList;
    }

    public void setArrayDataList(Block[] arrayDataList) {
        this.arrayDataList = arrayDataList;
    }

    public StreamCache getCache() {
        return this.cache;
    }

    public void setCache(StreamCache cache) {
        this.cache = cache;
    }

    public int read(byte[] bytes, int i, int i1) throws IOException {
        return this.transfer(bytes, i, i1);
    }

    public int read() throws IOException {
        int l = this.transfer(this.bufByte, 0, 1);
        if (l == -1) {
            return -1;
        }
        return this.bufByte[0];
    }

    private int transfer(byte[] dest, int destPos, int length) {
        if (this.currentSegmentIndex >= this.arrayDataList.length) {
            return -1;
        }
        Block block = this.arrayDataList[this.currentSegmentIndex];
        RegionMemory origin = block.buffer;
        int read = 0;
        while (length > 0 && origin != null) {
            int lenRead;
            if (length > block.length - this.currentDataindex) {
                lenRead = block.length - this.currentDataindex;
                origin.read((long)this.currentDataindex, dest, destPos, lenRead);
                this.cache.countReadData += (long)lenRead;
                length -= lenRead;
                read += lenRead;
                destPos += lenRead;
                this.currentDataindex = 0;
                ++this.currentSegmentIndex;
                if (this.currentSegmentIndex < this.arrayDataList.length) {
                    block = this.arrayDataList[this.currentSegmentIndex];
                    origin = block == null ? null : block.buffer;
                    continue;
                }
                origin = null;
                continue;
            }
            lenRead = length;
            origin.read((long)this.currentDataindex, dest, destPos, lenRead);
            this.cache.countReadData += (long)lenRead;
            destPos += lenRead;
            read += lenRead;
            length -= lenRead;
            this.currentDataindex += lenRead;
        }
        return read;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.arrayDataList.length > 0) {
            Block first = this.arrayDataList[0];
            byte[] tmp = new byte[first.length];
            for (Block block : this.arrayDataList) {
                block.buffer.read(0L, tmp, 0, block.length);
                out.write(tmp, 0, block.length);
            }
        }
    }

    public long getId() {
        return this.map.getId();
    }

    public long getSize() {
        return this.map.getLength();
    }

    public long getTimeToLive() {
        return this.map.getTimeToLive();
    }

    public long getCreationTime() {
        return this.map.getCreationTime();
    }

    public long getTimeToIdle() {
        return this.map.getTimeToIdle();
    }

    public long getMostRecentTime() {
        return this.map.getMostRecentTime();
    }

    public long getExpirationTime() {
        return this.map.getExpirationTime();
    }

    public long getTimeToLiveRemaining() {
        return this.map.getTimeToLiveRemaining();
    }

    public long getTimeToIdleRemaining() {
        return this.map.getTimeToIdleRemaining();
    }

    public short getFlag() {
        return this.map.getFlag();
    }

    public boolean isOverrideMetadata() {
        return false;
    }
}

