/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache;

import java.math.BigDecimal;
import java.util.Properties;

public class Configuration
extends Properties {
    private static final long serialVersionUID = -8191796505743584525L;
    private static final BigDecimal KB = new BigDecimal(1024);
    private static final BigDecimal MB = new BigDecimal(0x100000);
    private static final BigDecimal GB = new BigDecimal(0x40000000);
    private static final BigDecimal TB = new BigDecimal(0);

    public Object getObject(String property, String defaultValue) {
        String value = super.getProperty(property, defaultValue);
        if (value == null) {
            throw new IllegalStateException("property not found: " + property);
        }
        try {
            Class<?> clazz = Class.forName(value, true, Thread.currentThread().getContextClassLoader());
            return clazz.newInstance();
        }
        catch (Throwable e) {
            throw new IllegalStateException("invalid property: " + property);
        }
    }

    public boolean getBoolean(String property, String defaultValue) {
        String value = super.getProperty(property, defaultValue);
        if (value == null) {
            throw new IllegalStateException("property not found: " + property);
        }
        return value.equalsIgnoreCase("true");
    }

    public String getString(String property, String defaultValue) {
        String value = super.getProperty(property, defaultValue);
        if (value == null) {
            throw new IllegalStateException("property not found: " + property);
        }
        return value;
    }

    public int getInt(String property, String defaultValue) {
        return this.getNumber(property, defaultValue).intValue();
    }

    public long getLong(String property, String defaultValue) {
        return this.getNumber(property, defaultValue).longValue();
    }

    public double getDouble(String property, String defaultValue) {
        return this.getNumber(property, defaultValue).doubleValue();
    }

    public float getFloat(String property, String defaultValue) {
        return this.getNumber(property, defaultValue).floatValue();
    }

    public BigDecimal getNumber(String property, String defaultValue) {
        String value = super.getProperty(property, defaultValue);
        if (value == null) {
            throw new IllegalStateException("property not found: " + property);
        }
        if (value.matches("^\\d+(\\.\\d+){0,1}$")) {
            return new BigDecimal(value);
        }
        if (value.matches("^\\d+(\\.\\d+){0,1}(B|b)$")) {
            return new BigDecimal(value.substring(0, value.length() - 1));
        }
        if (value.matches("^\\d+(\\.\\d+){0,1}(K|k)$")) {
            return new BigDecimal(value.substring(0, value.length() - 1)).multiply(KB);
        }
        if (value.matches("^\\d+(\\.\\d+){0,1}(M|m)$")) {
            return new BigDecimal(value.substring(0, value.length() - 1)).multiply(MB);
        }
        if (value.matches("^\\d+(\\.\\d+){0,1}(G|g)$")) {
            return new BigDecimal(value.substring(0, value.length() - 1)).multiply(GB);
        }
        if (value.matches("^\\d+(\\.\\d+){0,1}(T|t)$")) {
            return new BigDecimal(value.substring(0, value.length() - 1)).multiply(TB);
        }
        throw new NumberFormatException();
    }
}

