/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache;

import java.io.Serializable;

class DataMap
implements Serializable {
    private static final long serialVersionUID = -2531845084336308095L;
    private long id;
    private long timeToLive;
    private long creationTime;
    private long timeToIdle;
    private short flag;
    private long firstSegment;
    private int segments;
    private long length;
    private long mostRecentTime;

    public DataMap() {
        this(-1L, 0L, -1L, 0L, 0, -1, 0, 0L, 0L);
    }

    public DataMap(long id, long timeToLive, long creationTime, long timeToIdle, short flag, int firstSegment, int segments, long length, long mostRecentTime) {
        this.id = id;
        this.timeToLive = timeToLive;
        this.creationTime = creationTime;
        this.timeToIdle = timeToIdle;
        this.flag = flag;
        this.firstSegment = firstSegment;
        this.segments = segments;
        this.length = length;
        this.mostRecentTime = mostRecentTime;
    }

    public long getExpirationTime() {
        long ttlExpiry = this.timeToLive == 0L ? Long.MAX_VALUE : this.creationTime + this.timeToLive;
        long ttiExpiry = this.timeToIdle == 0L ? Long.MAX_VALUE : this.mostRecentTime + this.timeToIdle;
        return Math.min(ttlExpiry, ttiExpiry);
    }

    public long getTimeToLiveRemaining() {
        if (this.timeToLive == 0L) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        long timeToLiveRemaining = this.creationTime + this.timeToLive - currentTime;
        return timeToLiveRemaining;
    }

    public long getTimeToIdleRemaining() {
        if (this.timeToIdle == 0L) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        long timeToIdleRemaining = this.mostRecentTime + this.timeToIdle - currentTime;
        return timeToIdleRemaining;
    }

    public boolean isDead() {
        long currentTime = System.currentTimeMillis();
        return currentTime > this.getExpirationTime();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getTimeToIdle() {
        return this.timeToIdle;
    }

    public void setTimeToIdle(long timeToIdle) {
        this.timeToIdle = timeToIdle;
    }

    public short getFlag() {
        return this.flag;
    }

    public void setFlag(short flag) {
        this.flag = flag;
    }

    public long getFirstSegment() {
        return this.firstSegment;
    }

    public void setFirstSegment(long firstSegment) {
        this.firstSegment = firstSegment;
    }

    public int getSegments() {
        return this.segments;
    }

    public void setSegments(int segments) {
        this.segments = segments;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getMostRecentTime() {
        return this.mostRecentTime;
    }

    public void setMostRecentTime(long mostRecentTime) {
        this.mostRecentTime = mostRecentTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataMap other = (DataMap)obj;
        return this.id == other.id;
    }
}

