/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache;

class HugeListCalculator {
    HugeListCalculator() {
    }

    public static HugeListInfo calculate(long dataBufferSize, long dataPageSize, long blockSize, double dataSwapFactor) {
        if (dataBufferSize <= 0L) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        if (dataPageSize <= 0L) {
            throw new IllegalArgumentException("slab size <= 0");
        }
        if (blockSize <= 0L) {
            throw new IllegalArgumentException("block size <= 0");
        }
        if (dataPageSize > dataBufferSize) {
            throw new IllegalArgumentException("slab size > buffer size");
        }
        if (blockSize > dataPageSize) {
            throw new IllegalArgumentException("block size > slab size");
        }
        double subLists = dataBufferSize / (blockSize * 2048L);
        subLists = subLists > 12.0 ? 12.0 : subLists;
        subLists = subLists == 0.0 ? 1.0 : subLists;
        dataBufferSize = (long)((double)dataBufferSize / subLists);
        double blocksLength = dataBufferSize / blockSize;
        blocksLength = dataBufferSize % blockSize > 0L ? blocksLength + 1.0 : blocksLength;
        double blocksPerPage = dataPageSize / blockSize;
        blocksPerPage = dataPageSize % blockSize > 0L ? blocksPerPage + 1.0 : blocksPerPage;
        double pageFactor = blocksPerPage / blocksLength;
        double swapBufferSize = (double)dataBufferSize * dataSwapFactor;
        double swapBlocks = swapBufferSize / (double)blockSize;
        swapBlocks = swapBufferSize % (double)blockSize > 0.0 ? swapBlocks + 1.0 : swapBlocks;
        double swapFactor = swapBlocks / blocksLength;
        if (swapBlocks <= 0.0) {
            throw new IllegalArgumentException("swap factor is very little");
        }
        return new HugeListInfo((int)blocksLength, swapFactor, pageFactor, (int)subLists);
    }

    public static class HugeListInfo {
        private int maxCapacityElements;
        private double clearFactorElements;
        private double fragmentFactorElements;
        private int subLists;

        public HugeListInfo(int maxCapacityElements, double clearFactorElements, double fragmentFactorElements, int subLists) {
            this.maxCapacityElements = maxCapacityElements;
            this.clearFactorElements = clearFactorElements;
            this.fragmentFactorElements = fragmentFactorElements;
            this.subLists = subLists;
        }

        public int getSubLists() {
            return this.subLists;
        }

        public void setSubLists(int subLists) {
            this.subLists = subLists;
        }

        public int getMaxCapacityElements() {
            return this.maxCapacityElements;
        }

        public void setMaxCapacityElements(int maxCapacityElements) {
            this.maxCapacityElements = maxCapacityElements;
        }

        public double getClearFactorElements() {
            return this.clearFactorElements;
        }

        public void setClearFactorElements(double clearFactorElements) {
            this.clearFactorElements = clearFactorElements;
        }

        public double getFragmentFactorElements() {
            return this.fragmentFactorElements;
        }

        public void setFragmentFactorElements(double fragmentFactorElements) {
            this.fragmentFactorElements = fragmentFactorElements;
        }

        public String toString() {
            return "HugeListInfo [maxCapacityElements=" + this.maxCapacityElements + ", clearFactorElements=" + this.clearFactorElements + ", fragmentFactorElements=" + this.fragmentFactorElements + ", subLists=" + this.subLists + "]";
        }
    }
}

