/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.brandao.brcache.Block;
import org.brandao.brcache.CacheErrors;
import org.brandao.brcache.CacheInputStream;
import org.brandao.brcache.CorruptedDataException;
import org.brandao.brcache.DataMap;
import org.brandao.brcache.HugeListCalculator;
import org.brandao.brcache.ItemCacheInputStream;
import org.brandao.brcache.RecoverException;
import org.brandao.brcache.StorageException;
import org.brandao.brcache.collections.Collections;
import org.brandao.brcache.collections.HugeArrayReferenceList;
import org.brandao.brcache.collections.StringTreeMap;
import org.brandao.brcache.collections.Swapper;
import org.brandao.brcache.collections.treehugemap.CharNode;
import org.brandao.brcache.memory.Memory;
import org.brandao.brcache.memory.RegionMemory;

public abstract class StreamCache
implements Serializable {
    private static final long serialVersionUID = 8023029671447700902L;
    private static final int ENTRY_BINARY_SIZE = 48;
    private static final int NODE_BINARY_SIZE = CharNode.DATA_SIZE + 48;
    private static final int INDEX_BINARY_SIZE = 106;
    private static final Class<?> ITEM_CACHE_INPUTSTREAM_CLASS = ItemCacheInputStream.class;
    private Memory memory;
    private StringTreeMap<DataMap> dataMap;
    private HugeArrayReferenceList<Block> dataList;
    private int segmentSize;
    private long maxBytesToStorageEntry;
    private int maxLengthKey;
    private Swapper swapper;
    private volatile long modCount;
    volatile long countRead;
    volatile long countWrite;
    volatile long countRemoved;
    volatile long countReadData;
    volatile long countWriteData;
    volatile long countRemovedData;
    private boolean deleteOnExit;

    public StreamCache() {
        this.dataMap = null;
        this.dataList = null;
        this.segmentSize = -1;
        this.maxBytesToStorageEntry = -1L;
        this.maxLengthKey = -1;
    }

    public StreamCache(long nodeBufferSize, long nodePageSize, double nodeSwapFactor, long indexBufferSize, long indexPageSize, double indexSwapFactor, long dataBufferSize, long dataPageSize, long blockSize, double dataSwapFactor, long maxSizeEntry, int maxSizeKey, Swapper swapper, int quantitySwaperThread, Memory memory) {
        this.init(nodeBufferSize, nodePageSize, nodeSwapFactor, indexBufferSize, indexPageSize, indexSwapFactor, dataBufferSize, dataPageSize, blockSize, dataSwapFactor, maxSizeEntry, maxSizeKey, swapper, quantitySwaperThread, memory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(long nodeBufferSize, long nodePageSize, double nodeSwapFactor, long indexBufferSize, long indexPageSize, double indexSwapFactor, long dataBufferSize, long dataPageSize, long blockSize, double dataSwapFactor, long maxSizeEntry, int maxSizeKey, Swapper swapper, int quantitySwaperThread, Memory memory) {
        this.memory = memory;
        this.modCount = 0L;
        this.segmentSize = (int)blockSize;
        this.maxBytesToStorageEntry = maxSizeEntry;
        this.maxLengthKey = maxSizeKey;
        this.deleteOnExit = true;
        this.swapper = swapper;
        Class<Collections> clazz = Collections.class;
        synchronized (Collections.class) {
            HugeListCalculator.HugeListInfo indexInfo;
            HugeListCalculator.HugeListInfo nodeInfo;
            try {
                HugeListCalculator.HugeListInfo dataInfo = HugeListCalculator.calculate(dataBufferSize, dataPageSize, blockSize, dataSwapFactor);
                this.dataList = new HugeArrayReferenceList("data", dataInfo.getMaxCapacityElements(), dataInfo.getClearFactorElements(), dataInfo.getFragmentFactorElements(), this.swapper.clone(), quantitySwaperThread, dataInfo.getSubLists());
                this.dataList.setDeleteOnExit(false);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("fail create data buffer", e);
            }
            try {
                nodeInfo = HugeListCalculator.calculate(nodeBufferSize, nodePageSize, NODE_BINARY_SIZE, nodeSwapFactor);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("fail create nodes buffer", e);
            }
            try {
                indexInfo = HugeListCalculator.calculate(indexBufferSize, indexPageSize, 106L, indexSwapFactor);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("fail create index buffer", e);
            }
            try {
                this.dataMap = new StringTreeMap("dataMap", nodeInfo.getMaxCapacityElements(), nodeInfo.getClearFactorElements(), nodeInfo.getFragmentFactorElements(), this.swapper.clone(), quantitySwaperThread, nodeInfo.getSubLists(), indexInfo.getMaxCapacityElements(), indexInfo.getClearFactorElements(), indexInfo.getFragmentFactorElements(), this.swapper.clone(), quantitySwaperThread, indexInfo.getSubLists());
                this.dataMap.setDeleteOnExit(false);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("fail data map", e);
            }
            return;
        }
    }

    protected boolean putStream(String key, InputStream inputData, long timeToLive, long timeToIdle) throws StorageException {
        if (timeToLive < 0L) {
            throw new StorageException(CacheErrors.ERROR_1029, new Object[0]);
        }
        if (timeToIdle < 0L) {
            throw new StorageException(CacheErrors.ERROR_1028, new Object[0]);
        }
        if (key.length() > this.maxLengthKey) {
            throw new StorageException(CacheErrors.ERROR_1008, new Object[0]);
        }
        DataMap oldMap = null;
        DataMap map = new DataMap();
        if (ITEM_CACHE_INPUTSTREAM_CLASS.isAssignableFrom(inputData.getClass())) {
            ItemCacheInputStream input = (ItemCacheInputStream)inputData;
            DataMap itemMetadata = input.getMap();
            map.setCreationTime(itemMetadata.getCreationTime());
            map.setMostRecentTime(itemMetadata.getMostRecentTime());
            map.setTimeToIdle(itemMetadata.getTimeToIdle());
            map.setTimeToLive(itemMetadata.getTimeToLive());
            if (map.isDead()) {
                this.remove(key, map);
                return false;
            }
        } else {
            map.setCreationTime(System.currentTimeMillis());
            map.setMostRecentTime(map.getCreationTime());
            map.setTimeToIdle(timeToIdle);
            map.setTimeToLive(timeToLive);
        }
        map.setId(this.modCount++);
        try {
            this.putData(map, inputData);
        }
        catch (Throwable e) {
            try {
                this.releaseSegments(map);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            throw e instanceof StorageException ? (StorageException)e : new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
        try {
            oldMap = this.dataMap.put(key, map);
        }
        catch (Throwable e) {
            try {
                this.releaseSegments(map);
                this.dataMap.remove(key, map);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
        finally {
            if (oldMap != null) {
                this.releaseSegments(oldMap);
                ++this.countRemoved;
            }
        }
        ++this.countWrite;
        return oldMap != null;
    }

    protected boolean replaceStream(String key, InputStream inputData, long timeToLive, long timeToIdle) throws StorageException {
        if (timeToLive < 0L) {
            throw new StorageException(CacheErrors.ERROR_1029, new Object[0]);
        }
        if (timeToIdle < 0L) {
            throw new StorageException(CacheErrors.ERROR_1028, new Object[0]);
        }
        if (key.length() > this.maxLengthKey) {
            throw new StorageException(CacheErrors.ERROR_1008, new Object[0]);
        }
        DataMap oldMap = null;
        DataMap map = new DataMap();
        map.setCreationTime(System.currentTimeMillis());
        map.setMostRecentTime(map.getCreationTime());
        map.setTimeToIdle(timeToIdle);
        map.setTimeToLive(timeToLive);
        map.setId(this.modCount++);
        try {
            this.putData(map, inputData);
        }
        catch (Throwable e) {
            try {
                this.releaseSegments(map);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            throw e instanceof StorageException ? (StorageException)e : new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
        try {
            oldMap = this.dataMap.replace(key, map);
        }
        catch (Throwable e) {
            try {
                this.releaseSegments(map);
                this.dataMap.remove(key, map);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
        finally {
            if (oldMap != null) {
                this.releaseSegments(oldMap);
            }
        }
        if (oldMap != null) {
            ++this.countWrite;
            return true;
        }
        return false;
    }

    protected InputStream putIfAbsentStream(String key, InputStream inputData, long timeToLive, long timeToIdle) throws StorageException {
        if (timeToLive < 0L) {
            throw new StorageException(CacheErrors.ERROR_1029, new Object[0]);
        }
        if (timeToIdle < 0L) {
            throw new StorageException(CacheErrors.ERROR_1028, new Object[0]);
        }
        if (key.length() > this.maxLengthKey) {
            throw new StorageException(CacheErrors.ERROR_1008, new Object[0]);
        }
        DataMap oldMap = null;
        DataMap map = new DataMap();
        InputStream in = null;
        map.setCreationTime(System.currentTimeMillis());
        map.setMostRecentTime(map.getCreationTime());
        map.setTimeToIdle(timeToIdle);
        map.setTimeToLive(timeToLive);
        map.setId(this.modCount++);
        try {
            this.putData(map, inputData);
        }
        catch (Throwable e) {
            try {
                this.releaseSegments(map);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            throw e instanceof StorageException ? (StorageException)e : new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
        try {
            oldMap = this.dataMap.putIfAbsent(key, map);
        }
        catch (Throwable e) {
            try {
                this.releaseSegments(map);
                this.dataMap.remove(key, map);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
        if (oldMap != null) {
            this.releaseSegments(map);
            in = this.getStream(key, oldMap);
        } else {
            ++this.countWrite;
        }
        if (oldMap != null) {
            if (in == null) {
                throw new StorageException(CacheErrors.ERROR_1030, new Object[0]);
            }
            return in;
        }
        return null;
    }

    protected InputStream getStream(String key) throws RecoverException {
        DataMap map = (DataMap)this.dataMap.get(key);
        return map == null ? null : this.getStream(key, map);
    }

    private InputStream getStream(String key, DataMap map) throws RecoverException {
        try {
            ++this.countRead;
            if (map.isDead()) {
                this.remove(key, map);
                return null;
            }
            if (map.getTimeToIdle() > 0L) {
                map.setMostRecentTime(System.currentTimeMillis());
                this.dataMap.replace(key, map, map);
            }
            Block[] segments = new Block[map.getSegments()];
            Block current = this.dataList.get(map.getFirstSegment());
            int i = 0;
            while (current != null) {
                if (current.id != map.getId() || current.segment != i) {
                    throw new CorruptedDataException("invalid segment: " + current.id + ":" + map.getId() + " " + current.segment + ":" + i);
                }
                segments[i] = current;
                current = current.nextBlock < 0L ? null : this.dataList.get(current.nextBlock);
                ++i;
            }
            return new CacheInputStream(this, map, segments);
        }
        catch (CorruptedDataException e) {
            return null;
        }
        catch (Throwable e) {
            throw new RecoverException(e, CacheErrors.ERROR_1021, new Object[0]);
        }
    }

    protected boolean removeStream(String key) throws StorageException {
        try {
            DataMap data = (DataMap)this.dataMap.get(key);
            if (data != null) {
                this.remove(key, data);
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1022, new Object[0]);
        }
    }

    public boolean containsKey(String key) {
        return this.dataMap.containsKey(key);
    }

    private void remove(String key, DataMap data) {
        if (this.dataMap.remove(key, data)) {
            this.releaseSegments(data);
            ++this.countRemoved;
        }
    }

    private void putData(DataMap map, InputStream inputData) throws StorageException, InterruptedException {
        int writeData = 0;
        byte[] buffer = new byte[this.segmentSize];
        int index = 0;
        Block lastBlock = null;
        long lastSegment = -1L;
        try {
            int read;
            while ((read = inputData.read(buffer, 0, this.segmentSize)) != -1) {
                writeData += read;
                RegionMemory data = this.memory.alloc(this.segmentSize);
                data.write(0L, buffer, 0, read);
                Block block = new Block(map.getId(), index++, data, read);
                Long segment = this.dataList.insert(block);
                if (lastBlock != null) {
                    lastBlock.nextBlock = segment;
                    this.dataList.set(lastSegment, lastBlock);
                } else {
                    map.setFirstSegment(segment);
                }
                lastBlock = block;
                lastSegment = segment;
            }
            this.countWriteData += (long)writeData;
            if ((long)writeData > this.maxBytesToStorageEntry) {
                throw new StorageException(CacheErrors.ERROR_1007, new Object[0]);
            }
            map.setLength(writeData);
            map.setSegments(index);
        }
        catch (StorageException e) {
            this.countRemovedData += (long)writeData;
            this.releaseSegments(map);
            throw e;
        }
        catch (IOException e) {
            this.countRemovedData += (long)writeData;
            this.releaseSegments(map);
            throw new StorageException(e, CacheErrors.ERROR_1014, new Object[0]);
        }
    }

    private void releaseSegments(DataMap map) {
        long segmentId = map.getFirstSegment();
        if (segmentId == -1L) {
            return;
        }
        Block current = this.dataList.get(segmentId);
        int i = 0;
        while (current != null) {
            if (current.id == map.getId() && current.segment == i) {
                this.dataList.remove(segmentId, current);
            }
            current = (segmentId = current.nextBlock) < 0L ? null : this.dataList.get(segmentId);
            ++i;
        }
        map.setFirstSegment(-1L);
    }

    public long getCountRead() {
        return this.countRead;
    }

    public long getCountWrite() {
        return this.countWrite;
    }

    public long getCountRemoved() {
        return this.countRemoved;
    }

    public long getCountReadData() {
        return this.countReadData;
    }

    public long getCountWriteData() {
        return this.countWriteData;
    }

    public long getCountRemovedData() {
        return this.countRemovedData;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    public void clear() {
        this.countRead = 0L;
        this.countReadData = 0L;
        this.countRemoved = 0L;
        this.countRemovedData = 0L;
        this.countWrite = 0L;
        this.countWriteData = 0L;
        this.dataList.clear();
        this.dataMap.clear();
    }

    public void destroy() {
        this.dataList.destroy();
        this.dataMap.destroy();
        this.swapper.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.deleteOnExit) {
                this.destroy();
            }
        }
        finally {
            super.finalize();
        }
    }
}

