/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.brandao.brcache.collections.CollectionSegment;
import org.brandao.brcache.collections.Entry;
import org.brandao.brcache.collections.Segment;
import org.brandao.brcache.collections.Swapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCollectionSegment<I, T>
implements CollectionSegment<I>,
Runnable,
Serializable {
    private static final long serialVersionUID = 7817500681111470845L;
    private static final int MAX_ITENS_PER_SEGMENT = 300;
    protected Segment<T>[] segments;
    private transient File path;
    private transient boolean hasCreatePath;
    private String id;
    private int maxCapacity;
    private int maxSegmentCapacity;
    private double fragmentSize;
    private double clearFactor;
    protected boolean readOnly;
    private Swapper swap;
    private boolean forceSwap;
    private BlockingQueue<Entry<T>> swapCandidates;
    private transient Thread[] swapperThreads;
    private boolean live;
    private volatile long onMemory;

    public AbstractCollectionSegment(String id, int maxCapacity, double clearFactor, double fragmentFactor, Swapper swap, int quantitySwaperThread) {
        int i;
        this.id = id;
        this.fragmentSize = (int)((double)maxCapacity * fragmentFactor);
        this.maxCapacity = maxCapacity;
        this.clearFactor = clearFactor;
        this.maxSegmentCapacity = (int)((double)maxCapacity / this.fragmentSize);
        this.swapCandidates = new LinkedBlockingQueue<Entry<T>>();
        this.readOnly = false;
        this.swap = swap;
        this.forceSwap = true;
        this.live = true;
        this.segments = new Segment[maxCapacity / 300 + (maxCapacity % 300 != 0 ? 1 : 0)];
        this.onMemory = 0L;
        this.swapperThreads = new Thread[quantitySwaperThread];
        this.swap.setId(this.id);
        int countMaxCapacity = maxCapacity;
        for (i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(swap, this.forceSwap, countMaxCapacity - 300 > 300 ? 300L : (long)countMaxCapacity, this.readOnly);
            countMaxCapacity -= 300;
        }
        for (i = 0; i < this.swapperThreads.length; ++i) {
            SwapperThread swapperThread = new SwapperThread(this.swapCandidates);
            this.swapperThreads[i] = new Thread((Runnable)swapperThread, id + "_" + i);
            this.swapperThreads[i].start();
        }
        Thread clearThread = new Thread(this);
        clearThread.start();
    }

    protected void add(Entry<T> item) {
        this.getSegment(item.getIndex()).add(item);
        ++this.onMemory;
    }

    protected Entry<T> remove(Entry<T> item) {
        Entry<T> e = this.getSegment(item.getIndex()).remove(item);
        --this.onMemory;
        return e;
    }

    protected Entry<T> getEntry(long index) {
        return this.getSegment(index).getEntry(index);
    }

    public Entry<T> reload(Entry<T> entity) {
        return this.getSegment(entity.getIndex()).reload(entity);
    }

    @Override
    public void run() {
        while (this.live) {
            try {
                Thread.sleep(10000L);
                this.clearLimit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected Segment<T> getSegment(long value) {
        return this.segments[(int)(value % (long)this.segments.length)];
    }

    public boolean isLive() {
        return this.live;
    }

    protected void clearLimit() {
        double i = (double)this.maxSegmentCapacity * this.clearFactor;
        double limit = (double)this.maxSegmentCapacity - i;
        if (this.maxSegmentCapacity > 0 && (double)this.onMemory > limit) {
            int count = 0;
            int free = 0;
            do {
                free = 0;
                for (Segment<T> seg : this.segments) {
                    if (seg.swapNextCandidate()) {
                        ++count;
                        continue;
                    }
                    ++free;
                }
            } while ((double)count < i && free != this.segments.length);
        }
    }

    protected boolean needSwap() {
        return this.maxSegmentCapacity > 0 && this.onMemory > (long)(this.maxSegmentCapacity - 2);
    }

    @Override
    public void flush() {
        for (Segment<T> seg : this.segments) {
            while (seg.swapNextCandidate()) {
            }
        }
    }

    public Map<Long, Entry<T>> getSegments() {
        throw new UnsupportedOperationException();
    }

    public File getPath() {
        return this.path;
    }

    public void setPath(File path) {
        this.path = path;
    }

    public boolean isHasCreatePath() {
        return this.hasCreatePath;
    }

    public void setHasCreatePath(boolean hasCreatePath) {
        this.hasCreatePath = hasCreatePath;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public int getMaxSegmentCapacity() {
        return this.maxSegmentCapacity;
    }

    public void setMaxSegmentCapacity(int maxSegmentCapacity) {
        this.maxSegmentCapacity = maxSegmentCapacity;
    }

    @Override
    public double getFragmentSize() {
        return this.fragmentSize;
    }

    public void setFragmentSize(float fragmentSize) {
        this.fragmentSize = fragmentSize;
    }

    public double getClearFactor() {
        return this.clearFactor;
    }

    public void setClearFactor(float clearFactor) {
        this.clearFactor = clearFactor;
    }

    @Override
    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isForceSwap() {
        return this.forceSwap;
    }

    public void setForceSwap(boolean forceSwap) {
        this.forceSwap = forceSwap;
    }

    public void clear() {
        for (Segment<T> seg : this.segments) {
            seg.clear();
        }
        this.swapCandidates.clear();
        this.swap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.live = false;
            for (Thread st : this.swapperThreads) {
                st.interrupt();
            }
        }
        finally {
            this.swapCandidates.clear();
            this.swap.destroy();
            for (Segment<T> seg : this.segments) {
                seg.clear();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SwapperThread
    implements Runnable {
        private BlockingQueue<Entry<T>> itens;

        public SwapperThread(BlockingQueue<Entry<T>> itens) {
            this.itens = itens;
        }

        @Override
        public void run() {
            while (AbstractCollectionSegment.this.live) {
                try {
                    Entry entry = this.itens.take();
                    AbstractCollectionSegment.this.getSegment(entry.getIndex()).swap(entry);
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) continue;
                    e.printStackTrace();
                }
            }
        }
    }
}

