/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.brandao.brcache.collections.CollectionSegmentImp;
import org.brandao.brcache.collections.Collections;
import org.brandao.brcache.collections.Swapper;
import org.brandao.brcache.collections.swapper.TreeFileSwapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCollectionReference<T> {
    private static final Empty EMPTY = new Empty();
    private BlockingQueue<Long> freeAddress = new LinkedBlockingQueue<Long>();
    private CollectionSegmentImp<Object> collection;
    private long lastPos = 0L;
    private boolean deleteOnExit = true;
    private Lock lock = new ReentrantLock();

    public ArrayCollectionReference() {
        this(null, 1000, 0.25, 0.03f, null, 1);
    }

    public ArrayCollectionReference(String id, int maxCapacityElements, double clearFactorElements, double fragmentFactorElements, Swapper swap, int quantityClearThread) {
        id = id == null ? Collections.getNextId() : id;
        swap = swap == null ? new TreeFileSwapper() : swap;
        this.collection = new CollectionSegmentImp(id == null ? null : id + "_array", maxCapacityElements, clearFactorElements, fragmentFactorElements, swap.clone(), quantityClearThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(T e) {
        Long index = (Long)this.freeAddress.poll();
        if (index == null) {
            this.lock.lock();
            try {
                index = this.lastPos++;
            }
            finally {
                this.lock.unlock();
            }
            long segment = (long)((double)index.longValue() / this.collection.getFragmentSize());
            long offset = (long)((double)index.longValue() % this.collection.getFragmentSize());
            try {
                this.collection.putEntity(segment, (int)offset, (Object)e);
            }
            catch (Throwable ex) {
                this.freeAddress.add(index);
            }
        } else {
            long segment = (long)((double)index.longValue() / this.collection.getFragmentSize());
            long offset = (long)((double)index.longValue() % this.collection.getFragmentSize());
            try {
                this.collection.putEntity(segment, (int)offset, (Object)e);
            }
            catch (Throwable ex) {
                this.freeAddress.add(index);
            }
        }
        return index;
    }

    public T set(long reference, T e) {
        long offset;
        long segment = (long)((double)reference / this.collection.getFragmentSize());
        Object o = this.collection.setEntity(segment, (int)(offset = (long)((double)reference % this.collection.getFragmentSize())), e);
        return (T)(o instanceof Empty ? null : o);
    }

    public T get(long reference) {
        long offset;
        long segment = (long)((double)reference / this.collection.getFragmentSize());
        Object o = this.collection.getEntity(segment, (int)(offset = (long)((double)reference % this.collection.getFragmentSize())));
        return (T)(o instanceof Empty ? null : o);
    }

    public boolean remove(long reference) {
        long offset;
        long segment = (long)((double)reference / this.collection.getFragmentSize());
        if (!EMPTY.equals(this.collection.replaceEntity(segment, (int)(offset = (long)((double)reference % this.collection.getFragmentSize())), EMPTY))) {
            this.freeAddress.add(reference);
            return true;
        }
        return false;
    }

    public boolean replace(long reference, T oldValue, T value) {
        long segment = (long)((double)reference / this.collection.getFragmentSize());
        long offset = (long)((double)reference % this.collection.getFragmentSize());
        return this.collection.replaceEntity(segment, (int)offset, oldValue, value);
    }

    public T replace(long reference, T value) {
        long offset;
        long segment = (long)((double)reference / this.collection.getFragmentSize());
        Object o = this.collection.replaceEntity(segment, (int)(offset = (long)((double)reference % this.collection.getFragmentSize())), value);
        return (T)(o instanceof Empty ? null : o);
    }

    public T putIfAbsent(long reference, T value) {
        long offset;
        long segment = (long)((double)reference / this.collection.getFragmentSize());
        Object o = this.collection.putIfAbsentEntity(segment, (int)(offset = (long)((double)reference % this.collection.getFragmentSize())), value);
        return (T)(o instanceof Empty ? null : o);
    }

    public boolean remove(long reference, T oldValue) {
        long offset;
        long segment = (long)((double)reference / this.collection.getFragmentSize());
        if (!EMPTY.equals(this.collection.replaceEntity(segment, (int)(offset = (long)((double)reference % this.collection.getFragmentSize())), oldValue, EMPTY))) {
            this.freeAddress.add(reference);
            return true;
        }
        return false;
    }

    public void setDeleteOnExit(boolean value) {
        this.deleteOnExit = value;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    public int size() {
        return (int)this.length();
    }

    public long length() {
        return this.lastPos;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void clear() {
        this.collection.clear();
    }

    public void destroy() {
        this.collection.destroy();
    }

    public void flush() {
        this.collection.flush();
    }

    public void setReadOnly(boolean value) {
        this.collection.setReadOnly(value);
    }

    public boolean isReadOnly() {
        return this.collection.isReadOnly();
    }

    private static class Empty
    implements Serializable {
        private static final long serialVersionUID = -881123035360397425L;

        private Empty() {
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object x) {
            return x instanceof Empty;
        }
    }
}

