/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArraySegment<K>
implements Serializable {
    private static final long serialVersionUID = -6110258049047837285L;
    private long id;
    private int size;
    private Object[] data;
    private int segmentSize;

    public ArraySegment(long id, int segmentSize) {
        this.segmentSize = segmentSize;
        this.id = id;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Object[] getData() {
        return this.data;
    }

    public void setData(K[] data) {
        this.data = data;
    }

    public int set(int index, K value) {
        if (this.data == null) {
            this.data = new Object[this.segmentSize];
        }
        if (index >= this.data.length) {
            throw new IndexOutOfBoundsException(index + " >= " + this.size);
        }
        this.data[index] = value;
        return index;
    }

    public K remove(int index) {
        if (index < 0 || index >= this.data.length) {
            throw new IndexOutOfBoundsException();
        }
        Object oldValue = this.data[index];
        this.data[index] = null;
        return (K)oldValue;
    }

    public K get(int index) {
        if (index >= this.data.length) {
            throw new IndexOutOfBoundsException(index + " >= " + this.size);
        }
        return (K)this.data[index];
    }

    public Object[] ToArray() {
        return this.data;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }
}

