/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.brandao.brcache.collections.Collections;
import org.brandao.brcache.collections.HugeArrayList;
import org.brandao.brcache.collections.Swapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheList<T>
implements List<T>,
Serializable {
    private static final long serialVersionUID = -617590377196604703L;
    private final HugeArrayList<T> internalList;
    private static Swapper swapper;

    public CacheList(int maxCapacityElementsOnMemory, double swapFactorElements, double fragmentFactorElements) {
        this.internalList = new HugeArrayList(Collections.getNextId(), maxCapacityElementsOnMemory, swapFactorElements, fragmentFactorElements, swapper, 1);
        this.internalList.setForceSwap(true);
    }

    @Override
    public int size() {
        return this.internalList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.internalList.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.internalList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.internalList.toArray();
    }

    @Override
    public <K> K[] toArray(K[] a) {
        return this.internalList.toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.internalList.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.internalList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.internalList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.internalList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.internalList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.internalList.removeAll(c);
    }

    @Override
    public void clear() {
        this.internalList.clear();
    }

    @Override
    public T get(int index) {
        return this.internalList.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.internalList.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.internalList.add(index, element);
    }

    @Override
    public T remove(int index) {
        return this.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.internalList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.internalList.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.internalList.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.internalList.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.internalList.subList(fromIndex, toIndex);
    }

    public static Swapper getSwapper() {
        return swapper;
    }

    public static void setSwapper(Swapper swapper) {
        CacheList.swapper = swapper;
    }

    public void setReadOnly(boolean value) {
        this.internalList.setReadOnly(value);
    }

    public boolean isReadOnly() {
        return this.internalList.isReadOnly();
    }

    public String getUniqueId() {
        return this.internalList.getUniqueId();
    }

    public void flush() {
        this.internalList.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        boolean original = this.internalList.isReadOnly();
        try {
            this.internalList.flush();
            this.internalList.setReadOnly(true);
            stream.defaultWriteObject();
        }
        finally {
            this.internalList.setReadOnly(original);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

