/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.io.Serializable;
import org.brandao.brcache.Cache;
import org.brandao.brcache.RecoverException;
import org.brandao.brcache.StorageException;
import org.brandao.brcache.collections.Entry;
import org.brandao.brcache.collections.Swapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheSwapper
implements Swapper,
Serializable {
    private static final long serialVersionUID = -1342760584177753822L;
    private String id;
    private long maxalive;
    private long maxIndex = -1L;
    private Cache cache;

    public CacheSwapper(Cache cache) {
        this.cache = cache;
    }

    @Override
    public void setId(String value) {
        this.id = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendItem(long index, Entry<?> item) {
        CacheSwapper cacheSwapper = this;
        synchronized (cacheSwapper) {
            if (this.maxIndex < index) {
                this.maxIndex = index;
            }
        }
        if (item.getItem() == null) {
            throw new IllegalStateException("invalid item: " + index);
        }
        try {
            this.sendItem(index, item.getItem());
        }
        catch (StorageException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void sendItem(long index, Object item) throws StorageException {
        this.cache.put(this.id + ":" + index, item, this.getMaxalive(), 0L);
    }

    @Override
    public Entry<?> getItem(long index) {
        try {
            Object item = this.cache.get(this.id + ":" + index);
            if (item == null) {
                return null;
            }
            Entry<Object> entry = new Entry<Object>(index, false, item);
            entry.setNeedReload(false);
            return entry;
        }
        catch (RecoverException ex) {
            throw new RuntimeException(ex);
        }
    }

    public long getMaxalive() {
        return this.maxalive;
    }

    public void setMaxalive(long maxalive) {
        this.maxalive = maxalive;
    }

    @Override
    public void clear() {
        try {
            this.clear(this.cache);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private void clear(Cache cache) throws StorageException {
        int i = 0;
        while ((long)i <= this.maxIndex) {
            cache.remove(this.id + ":" + i);
            ++i;
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public Swapper clone() {
        try {
            return (Swapper)super.clone();
        }
        catch (Throwable e) {
            return null;
        }
    }
}

