/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import org.brandao.brcache.collections.AbstractCollectionSegment;
import org.brandao.brcache.collections.ArraySegment;
import org.brandao.brcache.collections.Entry;
import org.brandao.brcache.collections.Swapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionSegmentImp<I>
extends AbstractCollectionSegment<I, ArraySegment<I>>
implements Serializable {
    private static final long serialVersionUID = 239844470898102007L;

    public CollectionSegmentImp(String id, int maxCapacity, double clearFactor, double fragmentFactor, Swapper swap, int quantitySwaperThread) {
        super(id, maxCapacity, clearFactor, fragmentFactor, swap, quantitySwaperThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public I getEntity(long segment, int index) {
        Lock lock = super.getSegment(segment).getLock();
        lock.lock();
        try {
            Entry entry = this.getEntry(segment);
            if (entry == null) {
                I i = null;
                return i;
            }
            Object k = ((ArraySegment)entry.getItem()).get(index);
            return (I)k;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putEntity(long segment, int index, I value) {
        if (this.readOnly) {
            throw new IllegalStateException("readOnly");
        }
        if (segment < 0L) {
            throw new IllegalStateException("segment");
        }
        if (index < 0) {
            throw new IllegalStateException("index");
        }
        Lock lock = super.getSegment(segment).getLock();
        lock.lock();
        try {
            Entry<Object> entry = super.getEntry(segment);
            if (entry == null) {
                ArraySegment<I> seg = new ArraySegment<I>(segment, (int)this.getFragmentSize());
                entry = new Entry(segment, seg);
                seg.set(index, value);
                this.add(entry);
                int n = index;
                return n;
            }
            ArraySegment seg = (ArraySegment)entry.getItem();
            entry.setNeedUpdate(true);
            int n = seg.set(index, value);
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I setEntity(long segment, int index, I value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (segment < 0L) {
            throw new IllegalStateException("segment");
        }
        if (index < 0) {
            throw new IllegalStateException("index");
        }
        Lock lock = super.getSegment(segment).getLock();
        lock.lock();
        try {
            Entry<Object> entry = super.getEntry(segment);
            if (entry == null) {
                if (index != -1) {
                    throw new IllegalStateException("index");
                }
                ArraySegment<I> seg = new ArraySegment<I>(segment, (int)this.getFragmentSize());
                entry = new Entry(segment, seg);
                seg.set(index, value);
                this.add(entry);
                I i = null;
                return i;
            }
            ArraySegment seg = (ArraySegment)entry.getItem();
            entry.setNeedUpdate(true);
            Object old = seg.get(index);
            seg.set(index, value);
            Object k = old;
            return (I)k;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean replaceEntity(long segment, int index, I oldValue, I value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (segment < 0L) {
            throw new IllegalStateException("segment");
        }
        if (index < 0) {
            throw new IllegalStateException("index");
        }
        Lock lock = super.getSegment(segment).getLock();
        lock.lock();
        try {
            Entry entry = super.getEntry(segment);
            if (entry != null) {
                ArraySegment seg = (ArraySegment)entry.getItem();
                Object old = seg.get(index);
                if (old != null && old.equals(oldValue)) {
                    seg.set(index, value);
                    entry.setNeedUpdate(true);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            throw new IllegalStateException("segment");
        }
        finally {
            lock.unlock();
        }
    }

    public I replaceEntity(long segment, int index, I value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (segment < 0L) {
            throw new IllegalStateException("segment");
        }
        if (index < 0) {
            throw new IllegalStateException("index");
        }
        Lock lock = super.getSegment(segment).getLock();
        lock.lock();
        try {
            Entry entry = super.getEntry(segment);
            if (entry != null) {
                ArraySegment seg = (ArraySegment)entry.getItem();
                Object old = seg.get(index);
                if (old != null) {
                    seg.set(index, value);
                    entry.setNeedUpdate(true);
                }
                Object k = old;
                return (I)k;
            }
            throw new IllegalStateException("segment");
        }
        finally {
            lock.unlock();
        }
    }

    public I putIfAbsentEntity(long segment, int index, I value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (segment < 0L) {
            throw new IllegalStateException("segment");
        }
        if (index < 0) {
            throw new IllegalStateException("index");
        }
        Lock lock = super.getSegment(segment).getLock();
        lock.lock();
        try {
            Entry entry = super.getEntry(segment);
            if (entry != null) {
                ArraySegment seg = (ArraySegment)entry.getItem();
                Object old = seg.get(index);
                if (old == null) {
                    seg.set(index, value);
                    entry.setNeedUpdate(true);
                }
                Object k = old;
                return (I)k;
            }
            throw new IllegalStateException("segment");
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public I removeEntity(long segment, int index) {
        throw new UnsupportedOperationException();
    }
}

