/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.io.File;
import java.net.InetAddress;
import java.util.Properties;

public class Collections {
    public static final String DEFAULT_TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final Properties configuration = new Properties();
    private static boolean initialized = false;
    private static File path;
    private static String defaultPath;
    private static File defaultFilePath;
    private static int defaultSegmentSize;
    private static volatile long collectionID;
    private static String serverId;
    private static String startTime;

    public static Properties getConfiguration() {
        return configuration;
    }

    public static String getNextId() {
        if (!initialized) {
            Collections.initialize();
        }
        return new String(serverId + "#" + startTime + "#" + "BRC" + "#" + Long.toString(collectionID++, 36));
    }

    public static void setPath(String aPath) {
        path = new File(aPath);
        if (!path.exists()) {
            path.mkdirs();
        }
    }

    public static File getPath() {
        return path == null ? defaultFilePath : path;
    }

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            serverId = addr.getHostAddress();
            startTime = Long.toString(System.currentTimeMillis(), 36);
        }
        catch (Exception e) {
            serverId = "localhost";
        }
        Collections.deleteDir(defaultFilePath);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Collections.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    static {
        defaultPath = DEFAULT_TMP_DIR + "/brcache_collections";
        defaultFilePath = new File(defaultPath);
        defaultSegmentSize = 120;
        collectionID = 0L;
    }
}

