/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.brandao.brcache.collections.ArrayCollectionReference;
import org.brandao.brcache.collections.CollectionSegmentImp;
import org.brandao.brcache.collections.Collections;
import org.brandao.brcache.collections.HugeIterator;
import org.brandao.brcache.collections.HugeList;
import org.brandao.brcache.collections.Swapper;
import org.brandao.brcache.collections.swapper.TreeFileSwapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HugeArrayList<T>
implements HugeList<T>,
Serializable {
    private static final long serialVersionUID = 2177932987390402265L;
    public static final int DEFAULT_MAX_CAPACITY_ELEMENT = 1000;
    public static final float DEFAULT_CLEAR_FACTOR_ELEMENT = 0.25f;
    public static final float DEFAULT_FRAGMENT_FACTOR_ELEMENT = 0.03f;
    private volatile int size = 0;
    private CollectionSegmentImp<T> elements;
    private boolean deleteOnExit = true;

    public HugeArrayList() {
        this(null, 1000, 0.25, 0.03f, null, 1);
    }

    public HugeArrayList(String id, int maxCapacityElements, double clearFactorElements, double fragmentFactorElements, Swapper swap, int quantityClearThread) {
        id = id == null ? Collections.getNextId() : id;
        swap = swap == null ? new TreeFileSwapper() : swap;
        this.elements = new CollectionSegmentImp(id, maxCapacityElements, clearFactorElements, fragmentFactorElements, swap, quantityClearThread);
    }

    public boolean isForceSwap() {
        return this.elements.isForceSwap();
    }

    public void setForceSwap(boolean forceSwap) {
        this.elements.setForceSwap(forceSwap);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.size; ++i) {
            T item = this.get(i);
            if (item == null || !item.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new HugeIterator(this);
    }

    @Override
    public Object[] toArray() {
        return this.toArray((K[])new Object[0]);
    }

    @Override
    public <K> K[] toArray(K[] a) {
        K[] result = Arrays.copyOf(a, this.size);
        for (int i = 0; i < this.size; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    @Override
    public T get(int index) {
        int localSize = this.size;
        if (index >= localSize) {
            throw new IndexOutOfBoundsException(index + " >= " + localSize);
        }
        long segmentId = (long)((double)index / this.elements.getFragmentSize());
        int idx = (int)((double)index % this.elements.getFragmentSize());
        return this.elements.getEntity(segmentId, idx);
    }

    @Override
    public synchronized boolean add(T e) {
        long segmentId = (long)((double)this.size / this.elements.getFragmentSize());
        this.elements.putEntity(segmentId, -1, e);
        ++this.size;
        return true;
    }

    @Override
    public synchronized T set(int index, T element) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(index + " > " + this.size);
        }
        int segmentId = (int)((double)index / this.elements.getFragmentSize());
        int idx = (int)((double)index % this.elements.getFragmentSize());
        T old = this.elements.getEntity(segmentId, idx);
        this.elements.putEntity((long)segmentId, idx, element);
        return old;
    }

    @Override
    public synchronized T remove(int index) {
        T old = this.get(index);
        for (int i = index; i < this.size; ++i) {
            T next = i + 1 < this.size ? (T)this.get(i + 1) : null;
            this.set(index, next);
        }
        --this.size;
        return old;
    }

    @Override
    public boolean remove(Object o) {
        int index = -1;
        for (int i = 0; i < this.size; ++i) {
            if (!o.equals(this.get(i))) continue;
            index = i;
            break;
        }
        if (index != -1) {
            return this.remove(index) != null;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object entity : c) {
            if (this.contains(entity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T type : c) {
            this.add(type);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object entity : c) {
            this.remove(entity);
        }
        return true;
    }

    @Override
    public boolean retainAll(ArrayCollectionReference<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized void clear() {
        this.elements.clear();
        this.size = 0;
    }

    public void destroy() {
        this.elements.destroy();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (!o.equals(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void flush() {
        this.elements.flush();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setReadOnly(boolean value) {
        this.elements.setReadOnly(value);
    }

    @Override
    public boolean isReadOnly() {
        return this.elements.isReadOnly();
    }

    public String getUniqueId() {
        return this.elements.getId();
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.deleteOnExit) {
                this.destroy();
            }
        }
        finally {
            super.finalize();
        }
    }
}

