/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.brandao.brcache.collections.ArrayCollectionReference;
import org.brandao.brcache.collections.Collections;
import org.brandao.brcache.collections.HugeReferenceList;
import org.brandao.brcache.collections.Swapper;
import org.brandao.brcache.collections.swapper.TreeFileSwapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HugeArrayReferenceList<T>
implements HugeReferenceList<T> {
    private static final long serialVersionUID = 1406571295066759006L;
    private ArrayCollectionReference<T>[] lists;
    private boolean deleteOnExit;

    public HugeArrayReferenceList() {
        this(null, 1000, 0.25, 0.03f, null, 1, 1);
    }

    public HugeArrayReferenceList(String id, int maxCapacityElements, double clearFactorElements, double fragmentFactorElements, Swapper swap, int quantityClearThread, int lists) {
        this.lists = new ArrayCollectionReference[lists];
        this.deleteOnExit = true;
        id = id == null ? Collections.getNextId() : id;
        swap = swap == null ? new TreeFileSwapper() : swap;
        for (int i = 0; i < this.lists.length; ++i) {
            this.lists[i] = new ArrayCollectionReference(id == null ? null : id + "_ref_" + i, maxCapacityElements, clearFactorElements, fragmentFactorElements, swap.clone(), quantityClearThread);
        }
    }

    @Override
    public boolean add(T e) {
        this.insert(e);
        return true;
    }

    @Override
    public long insert(T e) {
        long threadReference = Thread.currentThread().getId() % (long)this.lists.length;
        long index = this.lists[(int)threadReference].insert(e);
        long address = (index &= 0xFFFFFFFFL) << 8 | (threadReference &= 0xFFL);
        return address;
    }

    @Override
    public T set(long reference, T e) {
        long threadReference = reference & 0xFFL;
        long index = reference >> 8;
        return this.lists[(int)threadReference].set(index, e);
    }

    @Override
    public T get(long reference) {
        long threadReference = reference & 0xFFL;
        long index = reference >> 8;
        return this.lists[(int)threadReference].get(index);
    }

    @Override
    public boolean remove(long reference) {
        long threadReference = reference & 0xFFL;
        long index = reference >> 8;
        return this.lists[(int)threadReference].remove(index);
    }

    @Override
    public boolean replace(long reference, T oldValue, T value) {
        long threadReference = reference & 0xFFL;
        long index = reference >> 8;
        return this.lists[(int)threadReference].replace(index, oldValue, value);
    }

    @Override
    public T replace(long reference, T value) {
        long threadReference = reference & 0xFFL;
        long index = reference >> 8;
        return this.lists[(int)threadReference].replace(index, value);
    }

    @Override
    public T putIfAbsent(long reference, T value) {
        long threadReference = reference & 0xFFL;
        long index = reference >> 8;
        return this.lists[(int)threadReference].putIfAbsent(index, value);
    }

    @Override
    public boolean remove(long reference, T oldValue) {
        long threadReference = reference & 0xFFL;
        long index = reference >> 8;
        return this.lists[(int)threadReference].remove(index, oldValue);
    }

    @Override
    public void setDeleteOnExit(boolean value) {
        this.deleteOnExit = value;
    }

    @Override
    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    @Override
    public int size() {
        return (int)this.length();
    }

    @Override
    public long length() {
        long size = 0L;
        for (ArrayCollectionReference<T> l : this.lists) {
            size += l.length();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        for (ArrayCollectionReference<T> l : this.lists) {
            l.clear();
        }
    }

    @Override
    public void destroy() {
        for (ArrayCollectionReference<T> l : this.lists) {
            l.destroy();
        }
    }

    @Override
    public void flush() {
        for (ArrayCollectionReference<T> l : this.lists) {
            l.flush();
        }
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <K> K[] toArray(K[] a) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public T get(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setReadOnly(boolean value) {
        for (ArrayCollectionReference<T> l : this.lists) {
            l.setReadOnly(value);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.lists[0].isReadOnly();
    }
}

