/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.brandao.brcache.collections.Entry;
import org.brandao.brcache.collections.Swapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Segment<T> {
    protected Map<Long, Entry<T>> data = new HashMap<Long, Entry<T>>();
    protected Lock lock = new ReentrantLock();
    protected Swapper swap;
    protected boolean forceSwap;
    protected long maxSegmentCapacity;
    protected volatile Entry<T> firstItem;
    protected boolean readOnly;

    public Segment(Swapper swap, boolean forceSwap, long maxSegmentCapacity, boolean readOnly) {
        this.swap = swap;
        this.forceSwap = forceSwap;
        this.maxSegmentCapacity = maxSegmentCapacity;
        this.firstItem = null;
        this.readOnly = readOnly;
    }

    public void add(Entry<T> item) {
        if (this.forceSwap && this.needSwap()) {
            this.swapFirst();
        }
        this.data.put(item.getIndex(), item);
        this.addListedItemOnMemory(item);
    }

    protected Entry<T> getEntry(long index) {
        Entry<T> e = this.data.get(index);
        if (e == null) {
            return this.swapOnMemory(index);
        }
        this.realocItemListedOnMemory(e);
        return e;
    }

    public Entry<T> remove(Entry<T> item) {
        Entry<T> e = this.data.remove(item.getIndex());
        this.removeItemListedOnMemory(item);
        item.setItem(null);
        item.setNeedUpdate(false);
        item.setNeedReload(true);
        return e;
    }

    public Entry<T> reload(Entry<T> entity) {
        if (entity.isNeedReload()) {
            return this.swapOnMemory(entity.getIndex());
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swapNextCandidate() {
        this.lock.lock();
        try {
            Entry<T> item = this.firstItem;
            if (item != null) {
                this.swapOnDisk(item);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(Entry<T> item) {
        this.lock.lock();
        try {
            this.swapOnDisk(item);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void swapOnDisk(Entry<T> item) {
        Entry<T> removedItem;
        if (item.isNeedReload()) {
            return;
        }
        if (!this.readOnly && item.isNeedUpdate()) {
            this.swap.sendItem(item.getIndex(), item);
        }
        if (item != (removedItem = this.remove(item))) {
            throw new IllegalStateException();
        }
    }

    public Entry<T> swapOnMemory(long key) {
        Entry<?> entity;
        Entry<T> onMemoryEntity = this.data.get(key);
        if (onMemoryEntity != null) {
            return onMemoryEntity;
        }
        if (this.forceSwap && this.needSwap()) {
            this.swapFirst();
        }
        if ((entity = this.swap.getItem(key)) != null) {
            this.data.put(key, entity);
            this.addListedItemOnMemory(entity);
        }
        return entity;
    }

    protected void swapFirst() {
        Entry<T> item = this.firstItem;
        if (item != null) {
            this.swapOnDisk(item);
        }
    }

    private void addListedItemOnMemory(Entry<T> item) {
        if (this.firstItem == null) {
            this.firstItem = item;
            this.firstItem.setNext(this.firstItem);
            this.firstItem.setBefore(this.firstItem);
        } else {
            Entry<T> lastItem = this.firstItem.getBefore();
            item.setNext(this.firstItem);
            item.setBefore(lastItem);
            this.firstItem.setBefore(item);
            lastItem.setNext(item);
        }
    }

    private void removeItemListedOnMemory(Entry<T> item) {
        Entry<T> before = item.getBefore();
        Entry<T> next = item.getNext();
        if (this.firstItem == item) {
            if (this.firstItem == next) {
                this.firstItem = null;
            } else {
                this.firstItem = next;
                before.setNext(next);
                next.setBefore(before);
            }
        } else {
            before.setNext(next);
            next.setBefore(before);
        }
        item.setNext(null);
        item.setBefore(null);
    }

    private void realocItemListedOnMemory(Entry<T> item) {
        if (item.getBefore() == null && item.getNext() == null) {
            return;
        }
        if (this.firstItem != null && this.firstItem.getBefore() != item) {
            this.removeItemListedOnMemory(item);
            this.addListedItemOnMemory(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.firstItem = null;
            this.data.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean needSwap() {
        return this.maxSegmentCapacity > 0L && (long)this.data.size() > this.maxSegmentCapacity - 1L;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Lock getLock() {
        return this.lock;
    }

    public Swapper getSwap() {
        return this.swap;
    }

    public boolean isForceSwap() {
        return this.forceSwap;
    }

    public long getMaxSegmentCapacity() {
        return this.maxSegmentCapacity;
    }
}

