/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.brandao.brcache.collections.HugeArrayList;
import org.brandao.brcache.collections.Swapper;
import org.brandao.brcache.collections.TreeHugeMapNode;
import org.brandao.brcache.collections.TreeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeHugeMap<K extends TreeKey, T>
implements Map<K, T>,
Serializable {
    private static final long serialVersionUID = 4577949145861315961L;
    public static final int DEFAULT_MAX_CAPACITY_NODE = 2000;
    public static final float DEFAULT_CLEAR_FACTOR_NODE = 0.25f;
    public static final float DEFAULT_FRAGMENT_FACTOR_NODE = 0.03f;
    public static final int DEFAULT_MAX_CAPACITY_ELEMENT = 1000;
    public static final float DEFAULT_CLEAR_FACTOR_ELEMENT = 0.25f;
    public static final float DEFAULT_FRAGMENT_FACTOR_ELEMENT = 0.03f;
    private HugeArrayList<T> values;
    private HugeArrayList<Map<Object, TreeHugeMapNode<T>>> nodes;
    private TreeHugeMapNode<T> rootNode;

    public TreeHugeMap() {
        this(null, 2000, 0.25, 0.03f, null, 1, 1000, 0.25, 0.03f, null, 1);
    }

    public TreeHugeMap(String id, int maxCapacityNodes, double clearFactorNodes, double fragmentFactorNodes, Swapper swapNodes, int quantitySwaperThreadNodes, int maxCapacityElements, double clearFactorElements, double fragmentFactorElements, Swapper swapElements, int quantitySwaperThreadElements) {
        this.values = new HugeArrayList(id == null ? null : id + "Values", maxCapacityElements, clearFactorElements, fragmentFactorElements, swapElements, quantitySwaperThreadElements);
        this.nodes = new HugeArrayList(id == null ? null : id + "Nodes", maxCapacityNodes, clearFactorNodes, fragmentFactorNodes, swapNodes, quantitySwaperThreadNodes);
    }

    private boolean put(Object[] keys, int index, int limit, TreeHugeMapNode<T> node, T value, boolean override) {
        boolean needUpdate = false;
        if (index < limit) {
            TreeHugeMapNode<T> next = node.getNextNode(this.nodes, keys[index]);
            if (next == null) {
                next = new TreeHugeMapNode<T>(this.nodes);
                node.setNextNode(next, this.nodes, keys[index]);
                needUpdate = true;
            }
            if (this.put(keys, ++index, limit, next, value, override)) {
                node.updateNextNode(next, this.nodes, keys[index - 1]);
            }
        } else {
            node.setValue(value, this.values);
            needUpdate = true;
        }
        return needUpdate;
    }

    private T get(Object[] keys, int index, int limit, TreeHugeMapNode<T> node) {
        if (index < limit) {
            TreeHugeMapNode<T> next = node.getNextNode(this.nodes, keys[index]);
            if (next == null) {
                return null;
            }
            return this.get(keys, ++index, limit, next);
        }
        return node.getValue(this.values);
    }

    private T remove(Object[] keys, int index, int limit, TreeHugeMapNode<T> node) {
        if (index < limit) {
            TreeHugeMapNode<T> next = node.getNextNode(this.nodes, keys[index]);
            if (next == null) {
                return null;
            }
            return this.get(keys, ++index, limit, next);
        }
        T value = node.getValue(this.values);
        node.removeValue(this.values);
        return value;
    }

    @Override
    public synchronized T put(K key, T element) {
        Object[] keys = key.getNodes();
        if (this.rootNode == null) {
            this.rootNode = new TreeHugeMapNode<T>(this.nodes);
        }
        this.put(keys, 0, keys.length, this.rootNode, element, false);
        return null;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public T get(Object key) {
        Object[] keys = ((TreeKey)key).getNodes();
        if (this.rootNode == null) {
            return null;
        }
        return this.get(keys, 0, keys.length, this.rootNode);
    }

    @Override
    public synchronized T remove(Object key) {
        Object[] keys = ((TreeKey)key).getNodes();
        if (this.rootNode != null) {
            return this.remove(keys, 0, keys.length, this.rootNode);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends T> m) {
        for (TreeKey key : m.keySet()) {
            this.put((K)key, m.get(key));
        }
    }

    @Override
    public void clear() {
        this.values.clear();
        this.nodes.clear();
        this.rootNode = null;
    }

    public void flush() {
        this.nodes.flush();
        this.values.flush();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public Collection<T> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, T>> entrySet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setReadOnly(boolean value) {
        this.nodes.setReadOnly(value);
        this.values.setReadOnly(value);
    }

    public boolean isReadOnly() {
        return this.values.isReadOnly();
    }
}

