/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeHugeMapNode<T>
implements Serializable {
    private static final long serialVersionUID = -5212207702622818424L;
    private final Integer nodeIndex;
    private volatile int valueIndex = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeHugeMapNode(List<Map<Object, TreeHugeMapNode<T>>> nodes) {
        HashMap node = new HashMap();
        List<Map<Object, TreeHugeMapNode<T>>> list = nodes;
        synchronized (list) {
            nodes.add(node);
            this.nodeIndex = nodes.size() - 1;
        }
    }

    public TreeHugeMapNode<T> getNextNode(List<Map<Object, TreeHugeMapNode<T>>> nodes, Object key) {
        Map<Object, TreeHugeMapNode<T>> thisNode = nodes.get(this.nodeIndex);
        return thisNode.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextNode(TreeHugeMapNode<T> next, List<Map<Object, TreeHugeMapNode<T>>> nodes, Object key) {
        List<Map<Object, TreeHugeMapNode<T>>> list = nodes;
        synchronized (list) {
            Map<Object, TreeHugeMapNode<T>> thisNode = nodes.get(this.nodeIndex);
            thisNode.put(key, next);
            nodes.set(this.nodeIndex, thisNode);
        }
    }

    public void updateNextNode(TreeHugeMapNode<T> next, List<Map<Object, TreeHugeMapNode<T>>> nodes, Object key) {
        this.setNextNode(next, nodes, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(T value, List<T> values) {
        List<T> list = values;
        synchronized (list) {
            if (this.valueIndex == -1) {
                values.add(value);
                this.valueIndex = values.size() - 1;
            } else {
                values.set(this.valueIndex, value);
            }
        }
    }

    public T getValue(List<T> values) {
        if (this.valueIndex == -1) {
            return null;
        }
        return values.get(this.valueIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overrideValue(T value, List<T> values) {
        List<T> list = values;
        synchronized (list) {
            if (this.valueIndex == -1) {
                throw new IllegalArgumentException();
            }
            values.set(this.valueIndex, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(List<T> values) {
        List<T> list = values;
        synchronized (list) {
            if (this.valueIndex == -1) {
                throw new IllegalArgumentException();
            }
            values.remove(this.valueIndex);
        }
    }
}

