/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.brandao.brcache.collections.HugeArrayReferenceList;
import org.brandao.brcache.collections.HugeMap;
import org.brandao.brcache.collections.HugeReferenceList;
import org.brandao.brcache.collections.Swapper;
import org.brandao.brcache.collections.treehugemap.TreeMapKey;
import org.brandao.brcache.collections.treehugemap.TreeNode;
import org.brandao.brcache.collections.treehugemap.TreeNodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMap<K, T>
implements HugeMap<K, T>,
Serializable {
    private static final long serialVersionUID = 4577949145861315961L;
    public static final int DEFAULT_MAX_CAPACITY_NODE = 2000;
    public static final float DEFAULT_CLEAR_FACTOR_NODE = 0.25f;
    public static final float DEFAULT_FRAGMENT_FACTOR_NODE = 0.03f;
    public static final int DEFAULT_MAX_CAPACITY_ELEMENT = 1000;
    public static final float DEFAULT_CLEAR_FACTOR_ELEMENT = 0.25f;
    public static final float DEFAULT_FRAGMENT_FACTOR_ELEMENT = 0.03f;
    private HugeReferenceList<T> values;
    private HugeReferenceList<TreeNode<T>> nodes;
    private TreeNodes<T> treeNodes;

    public TreeMap() {
        this(null, 2000, 0.25, 0.03f, null, 1, 1, 1000, 0.25, 0.03f, null, 1, 1, null);
    }

    public TreeMap(String id, int maxCapacityNodes, double clearFactorNodes, double fragmentFactorNodes, Swapper swapNodes, int quantitySwaperThreadNodes, int subListsNodes, int maxCapacityElements, double clearFactorElements, double fragmentFactorElements, Swapper swapElements, int quantitySwaperThreadElements, int subListsElements, TreeNodes<T> treeNodes) {
        this.values = new HugeArrayReferenceList(id == null ? null : id + "Values", maxCapacityElements, clearFactorElements, fragmentFactorElements, swapElements, quantitySwaperThreadElements, subListsElements);
        this.nodes = new HugeArrayReferenceList<TreeNode<T>>(id == null ? null : id + "Nodes", maxCapacityNodes, clearFactorNodes, fragmentFactorNodes, swapNodes, quantitySwaperThreadNodes, subListsNodes);
        this.treeNodes = treeNodes;
        this.treeNodes.init(this.nodes);
    }

    private T put(TreeMapKey key, TreeNode<T> node, T value) {
        if (!this.treeNodes.isEquals(key, node)) {
            TreeNode<T> next = this.treeNodes.getNext(this.nodes, key, node, false);
            return this.put(key, next, value);
        }
        return this.treeNodes.setValue(this.values, node, value);
    }

    private boolean replace(TreeMapKey key, TreeNode<T> node, T oldValue, T value) {
        if (!this.treeNodes.isEquals(key, node)) {
            TreeNode<T> next = this.treeNodes.getNext(this.nodes, key, node, false);
            return this.replace(key, next, oldValue, value);
        }
        return this.treeNodes.replaceValue(this.values, node, oldValue, value);
    }

    private T replace(TreeMapKey key, TreeNode<T> node, T value) {
        if (!this.treeNodes.isEquals(key, node)) {
            TreeNode<T> next = this.treeNodes.getNext(this.nodes, key, node, false);
            return this.replace(key, next, value);
        }
        return this.treeNodes.replaceValue(this.values, node, value);
    }

    private T putIfAbsent(TreeMapKey key, TreeNode<T> node, T value) {
        if (!this.treeNodes.isEquals(key, node)) {
            TreeNode<T> next = this.treeNodes.getNext(this.nodes, key, node, false);
            return this.putIfAbsent(key, next, value);
        }
        return this.treeNodes.putIfAbsentValue(this.values, node, value);
    }

    private T get(TreeMapKey key, TreeNode<T> node) {
        if (!this.treeNodes.isEquals(key, node)) {
            TreeNode<T> next = this.treeNodes.getNext(this.nodes, key, node, true);
            if (next == null) {
                return null;
            }
            return this.get(key, next);
        }
        return this.treeNodes.getValue(this.values, node);
    }

    private T remove(TreeMapKey key, TreeNode<T> node) {
        if (!this.treeNodes.isEquals(key, node)) {
            TreeNode<T> next = this.treeNodes.getNext(this.nodes, key, node, true);
            if (next == null) {
                return null;
            }
            return this.remove(key, next);
        }
        return this.treeNodes.removeValue(this.values, node);
    }

    private boolean remove(TreeMapKey key, TreeNode<T> node, T oldValue) {
        if (!this.treeNodes.isEquals(key, node)) {
            TreeNode<T> next = this.treeNodes.getNext(this.nodes, key, node, true);
            if (next == null) {
                return false;
            }
            return this.remove(key, next, oldValue);
        }
        return this.treeNodes.removeValue(this.values, node, oldValue);
    }

    @Override
    public T put(K key, T element) {
        TreeMapKey k = this.treeNodes.getKey(key);
        TreeNode<T> root = this.treeNodes.getFirst(this.nodes);
        return this.put(k, root, element);
    }

    @Override
    public boolean replace(K key, T oldElement, T element) {
        TreeMapKey k = this.treeNodes.getKey(key);
        TreeNode<T> root = this.treeNodes.getFirst(this.nodes);
        return this.replace(k, root, oldElement, element);
    }

    @Override
    public T replace(K key, T element) {
        TreeMapKey k = this.treeNodes.getKey(key);
        TreeNode<T> root = this.treeNodes.getFirst(this.nodes);
        return this.replace(k, root, element);
    }

    @Override
    public T putIfAbsent(K key, T element) {
        TreeMapKey k = this.treeNodes.getKey(key);
        TreeNode<T> root = this.treeNodes.getFirst(this.nodes);
        return this.putIfAbsent(k, root, element);
    }

    @Override
    public void setDeleteOnExit(boolean value) {
        this.nodes.setDeleteOnExit(value);
        this.values.setDeleteOnExit(value);
    }

    @Override
    public boolean isDeleteOnExit() {
        return this.nodes.isDeleteOnExit();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public T get(Object key) {
        TreeMapKey k = this.treeNodes.getKey(key);
        TreeNode<T> root = this.treeNodes.getFirst(this.nodes);
        if (root == null) {
            return null;
        }
        return this.get(k, root);
    }

    @Override
    public T remove(Object key) {
        TreeMapKey k = this.treeNodes.getKey(key);
        TreeNode<T> root = this.treeNodes.getFirst(this.nodes);
        if (root == null) {
            return null;
        }
        return this.remove(k, root);
    }

    @Override
    public boolean remove(Object key, Object oldValue) {
        TreeMapKey k = this.treeNodes.getKey(key);
        TreeNode<T> root = this.treeNodes.getFirst(this.nodes);
        if (root == null) {
            return false;
        }
        return this.remove(k, root, oldValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends T> m) {
        for (K key : m.keySet()) {
            this.put(key, m.get(key));
        }
    }

    @Override
    public void clear() {
        this.values.clear();
        this.nodes.clear();
    }

    @Override
    public void destroy() {
        this.values.destroy();
        this.nodes.destroy();
    }

    @Override
    public void flush() {
        this.nodes.flush();
        this.values.flush();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public Set<Map.Entry<K, T>> entrySet() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public Collection<T> values() {
        return this.values;
    }

    @Override
    public void setReadOnly(boolean value) {
        this.nodes.setReadOnly(value);
        this.values.setReadOnly(value);
    }

    @Override
    public boolean isReadOnly() {
        return this.values.isReadOnly();
    }
}

