/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections.fileswapper;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.brandao.brcache.collections.fileswapper.AbstractEntityFile;
import org.brandao.brcache.collections.fileswapper.DataBlock;
import org.brandao.brcache.collections.fileswapper.DataInputStream;
import org.brandao.brcache.collections.fileswapper.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBlockEntityFile
extends AbstractEntityFile<DataBlock> {
    public static final byte LEN_HEADER = 11;
    public static final byte END_HEADER = 13;
    public static final byte EOF_FILE = 26;
    public static final byte REMOVED_STATUS = 13;
    public static final byte USED_STATUS = 31;
    private final int blockSize;
    private ReadWriteLock lock;

    public DataBlockEntityFile(File file, int blockSize) {
        super(file);
        this.firstRecord = 11;
        this.blockSize = blockSize;
        this.recordLength = this.blockSize + 13;
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    protected void writeEOF(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)26);
    }

    @Override
    protected void write(DataOutputStream stream, DataBlock entity) throws IOException {
        byte[] buffer = new byte[this.blockSize];
        if (entity != null) {
            byte[] data = entity.getData();
            int length = data.length;
            if (length > this.blockSize) {
                throw new IOException(length + " != " + this.blockSize);
            }
            System.arraycopy(data, 0, buffer, 0, length);
            stream.writeByte((byte)31);
            stream.writeInt(length);
            stream.writeLong(entity.getNextBlock());
            stream.write(buffer, 0, buffer.length);
        } else {
            stream.writeByte((byte)13);
            stream.writeInt(-1);
            stream.writeLong(-1L);
            stream.write(buffer, 0, buffer.length);
        }
    }

    @Override
    protected DataBlock read(DataInputStream stream) throws IOException {
        byte status = stream.readByte();
        if (status == 13) {
            return null;
        }
        int length = stream.readInt();
        long nextBlock = stream.readLong();
        byte[] data = new byte[length];
        stream.read(data, 0, data.length);
        DataBlock entity = new DataBlock();
        entity.setData(data);
        entity.setNextBlock(nextBlock);
        entity.setId(this.offset);
        return entity;
    }

    @Override
    protected void writeMetaData(DataOutputStream stream) throws IOException {
        stream.writeString("DTA", 6);
        stream.writeShort((short)this.firstRecord);
        stream.writeShort((short)this.recordLength);
        stream.writeByte((byte)13);
    }

    @Override
    protected void writeHeader() throws IOException {
        super.writeHeader();
        DataBlock first = new DataBlock();
        first.setNextBlock(-1L);
        first.setData(new byte[0]);
        this.write(first);
    }

    @Override
    protected void readMetaData(DataInputStream stream) throws IOException {
        String name = stream.readString(6);
        if (!"DTA".equals(name)) {
            throw new IOException("invalid file format");
        }
        this.firstRecord = stream.readShort();
        this.recordLength = stream.readShort();
        byte end = stream.readByte();
        if (end != 13) {
            throw new IOException("header corrupted");
        }
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }

    public int getBlockSize() {
        return this.blockSize;
    }
}

