/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections.fileswapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.brandao.brcache.collections.fileswapper.DataBlock;
import org.brandao.brcache.collections.fileswapper.DataBlockEntityFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataChain {
    private static final List<Long> EMPTY_LIST = new ArrayList<Long>();
    private static final byte[] EMPTY_DATA = new byte[0];

    public static Long save(List<DataBlock> list, DataBlockEntityFile handler) throws IOException {
        return DataChain.update(null, list, handler);
    }

    public static Long update(Long firstId, List<DataBlock> list, DataBlockEntityFile handler) throws IOException {
        handler.seek(0L);
        DataBlock free = (DataBlock)handler.read();
        if (free.getNextBlock() == -1L) {
            free = null;
        } else {
            handler.seek(free.getNextBlock());
            free = (DataBlock)handler.read();
        }
        Long lastId = null;
        List<Long> freeList = firstId == null ? EMPTY_LIST : DataChain.getUsedIds(firstId, handler);
        DataBlock[] arr = list.toArray(new DataBlock[0]);
        for (int i = arr.length - 1; i >= 0; --i) {
            DataBlock entity = arr[i];
            Long id = freeList.isEmpty() ? null : freeList.remove(0);
            entity.setNextBlock(lastId == null ? -1L : lastId);
            if (id != null) {
                lastId = id;
                entity.setId(id);
                handler.seek(id);
                handler.write(entity);
                continue;
            }
            if (free != null) {
                entity.setId(free.getId());
                handler.seek(entity.getId());
                handler.write(entity);
                lastId = entity.getId();
                if (free.getNextBlock() != -1L) {
                    handler.seek(free.getNextBlock());
                    free = (DataBlock)handler.read();
                    continue;
                }
                handler.seek(0L);
                handler.write(free);
                free = null;
                continue;
            }
            handler.seek(handler.length());
            entity.setId(handler.getOffset());
            handler.write(entity);
            lastId = entity.getId();
        }
        if (free != null) {
            handler.seek(0L);
            free.setNextBlock(free.getId());
            free.setData(EMPTY_DATA);
            free.setId(-1L);
            handler.write(free);
        }
        DataChain.remove(handler, freeList);
        return lastId;
    }

    public static void remove(Long firstId, DataBlockEntityFile handler) throws IOException {
        List<Long> freeList = DataChain.getUsedIds(firstId, handler);
        DataChain.remove(handler, freeList);
    }

    public static void remove(DataBlockEntityFile handler, List<Long> freeList) throws IOException {
        if (freeList.isEmpty()) {
            return;
        }
        handler.seek(0L);
        DataBlock firstBlock = (DataBlock)handler.read();
        long lastBlockId = firstBlock.getNextBlock();
        for (Long id : freeList) {
            DataBlock freeBlock = new DataBlock();
            freeBlock.setData(EMPTY_DATA);
            freeBlock.setId(id);
            freeBlock.setNextBlock(lastBlockId);
            lastBlockId = id;
            handler.seek(id);
            handler.write(freeBlock);
        }
        firstBlock.setNextBlock(lastBlockId);
        handler.seek(0L);
        handler.write(firstBlock);
    }

    public static List<DataBlock> reload(Long firstId, DataBlockEntityFile handler) throws IOException {
        ArrayList<DataBlock> list = new ArrayList<DataBlock>();
        DataBlock chain = null;
        if (firstId != null) {
            handler.seek(firstId);
            chain = (DataBlock)handler.read();
        }
        while (chain != null) {
            list.add(chain);
            Long nextId = chain.getNextBlock();
            if (nextId == -1L) break;
            handler.seek(nextId);
            chain = (DataBlock)handler.read();
        }
        return list;
    }

    private static List<Long> getUsedIds(Long firstId, DataBlockEntityFile handler) throws IOException {
        ArrayList<Long> list = new ArrayList<Long>();
        DataBlock chain = null;
        if (firstId != null) {
            handler.seek(firstId);
            chain = (DataBlock)handler.read();
        }
        while (chain != null) {
            list.add(chain.getId());
            Long nextId = chain.getNextBlock();
            if (nextId == -1L) break;
            handler.seek(nextId);
            chain = (DataBlock)handler.read();
        }
        return list;
    }
}

