/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections.fileswapper;

import java.io.IOException;
import java.io.InputStream;

public class DataInputStream {
    private byte[] buffer = new byte[8];
    private InputStream stream;

    public DataInputStream(InputStream stream) {
        this.stream = stream;
    }

    public long readLong() throws IOException {
        this.stream.read(this.buffer, 0, 8);
        return (long)this.buffer[0] & 0xFFL | (long)this.buffer[1] << 8 & 0xFF00L | (long)this.buffer[2] << 16 & 0xFF0000L | (long)this.buffer[3] << 24 & 0xFF000000L | (long)this.buffer[4] << 32 & 0xFF00000000L | (long)this.buffer[5] << 40 & 0xFF0000000000L | (long)this.buffer[6] << 48 & 0xFF000000000000L | (long)this.buffer[7] << 56 & 0xFF00000000000000L;
    }

    public int readInt() throws IOException {
        this.stream.read(this.buffer, 0, 4);
        return this.buffer[0] & 0xFF | this.buffer[1] << 8 & 0xFF00 | this.buffer[2] << 16 & 0xFF0000 | this.buffer[3] << 24 & 0xFF000000;
    }

    public short readShort() throws IOException {
        this.stream.read(this.buffer, 0, 2);
        return (short)((long)this.buffer[0] & 0xFFL | (long)((short)this.buffer[1] << 8 & 0xFF00));
    }

    public byte readByte() throws IOException {
        this.stream.read(this.buffer, 0, 1);
        return this.buffer[0];
    }

    public char readChar() throws IOException {
        this.stream.read(this.buffer, 0, 1);
        return (char)this.buffer[0];
    }

    public int read(byte[] b) throws IOException {
        return this.stream.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    public String readString(int length) throws IOException {
        byte[] value = new byte[length];
        this.stream.read(value, 0, length);
        short size = (short)((long)value[0] & 0xFFL | (long)(value[1] << 8 & 0xFF00));
        if (size == -1) {
            return null;
        }
        int init = 2;
        int end = init + size;
        if (end > value.length) {
            throw new IOException(end + " > " + value.length);
        }
        return new String(value, init, (int)size, "UTF-8");
    }
}

