/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections.fileswapper;

import java.io.IOException;
import java.io.OutputStream;

public class DataOutputStream {
    private byte[] buffer = new byte[8];
    private OutputStream stream;

    public DataOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    public void writeLong(long value) throws IOException {
        this.buffer[0] = (byte)(value & 0xFFL);
        this.buffer[1] = (byte)(value >> 8 & 0xFFL);
        this.buffer[2] = (byte)(value >> 16 & 0xFFL);
        this.buffer[3] = (byte)(value >> 24 & 0xFFL);
        this.buffer[4] = (byte)(value >> 32 & 0xFFL);
        this.buffer[5] = (byte)(value >> 40 & 0xFFL);
        this.buffer[6] = (byte)(value >> 48 & 0xFFL);
        this.buffer[7] = (byte)(value >> 56 & 0xFFL);
        this.stream.write(this.buffer, 0, 8);
    }

    public void writeInt(int value) throws IOException {
        this.buffer[0] = (byte)(value & 0xFF);
        this.buffer[1] = (byte)(value >> 8 & 0xFF);
        this.buffer[2] = (byte)(value >> 16 & 0xFF);
        this.buffer[3] = (byte)(value >> 24 & 0xFF);
        this.stream.write(this.buffer, 0, 4);
    }

    public void writeShort(short value) throws IOException {
        this.buffer[0] = (byte)(value & 0xFF);
        this.buffer[1] = (byte)(value >> 8 & 0xFF);
        this.stream.write(this.buffer, 0, 2);
    }

    public void writeByte(byte value) throws IOException {
        this.buffer[0] = value;
        this.stream.write(this.buffer, 0, 1);
    }

    public void writeChar(char value) throws IOException {
        this.buffer[0] = (byte)value;
        this.stream.write(this.buffer, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.stream.write(b);
    }

    public void write(int b) throws IOException {
        this.stream.write(b);
    }

    public void writeString(String value, int length) throws IOException {
        byte[] buffer = new byte[length];
        if (value != null) {
            byte[] data = value.getBytes("UTF-8");
            int size = data.length;
            int dataSize = size + 2;
            if (size > Short.MAX_VALUE) {
                throw new IOException(size + " > " + Short.MAX_VALUE);
            }
            if (dataSize > length) {
                throw new IOException(dataSize + " > " + length);
            }
            buffer[0] = (byte)(size & 0xFF);
            buffer[1] = (byte)(size >> 8 & 0xFF);
            System.arraycopy(data, 0, buffer, 2, data.length);
        } else {
            int size = -1;
            buffer[0] = (byte)(size & 0xFF);
            buffer[1] = (byte)(size >> 8 & 0xFF);
        }
        this.stream.write(buffer, 0, length);
    }
}

