/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections.fileswapper;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileAccess {
    private byte[] buffer = new byte[8];
    private RandomAccessFile randomAccessFile;
    private File file;

    public FileAccess(File file, RandomAccessFile randomAccessFile) {
        this.randomAccessFile = randomAccessFile;
        this.file = file;
    }

    public long readLong() throws IOException {
        this.randomAccessFile.readFully(this.buffer, 0, 8);
        return this.buffer[0] | this.buffer[1] << 8 | this.buffer[2] << 16 | this.buffer[3] << 24 | this.buffer[4] << 32 | this.buffer[5] << 40 | this.buffer[6] << 48 | this.buffer[7] << 56;
    }

    public void writeLong(long value) throws IOException {
        this.buffer[0] = (byte)(value & 0xFFL);
        this.buffer[1] = (byte)(value >> 8 & 0xFFL);
        this.buffer[2] = (byte)(value >> 16 & 0xFFL);
        this.buffer[3] = (byte)(value >> 24 & 0xFFL);
        this.buffer[4] = (byte)(value >> 32 & 0xFFL);
        this.buffer[5] = (byte)(value >> 40 & 0xFFL);
        this.buffer[6] = (byte)(value >> 48 & 0xFFL);
        this.buffer[7] = (byte)(value >> 56 & 0xFFL);
        this.randomAccessFile.write(this.buffer, 0, 8);
    }

    public int readInt() throws IOException {
        this.randomAccessFile.readFully(this.buffer, 0, 4);
        return this.buffer[0] | this.buffer[1] << 8 | this.buffer[2] << 16 | this.buffer[3] << 24;
    }

    public void writeInt(int value) throws IOException {
        this.buffer[0] = (byte)(value & 0xFF);
        this.buffer[1] = (byte)(value >> 8 & 0xFF);
        this.buffer[2] = (byte)(value >> 16 & 0xFF);
        this.buffer[3] = (byte)(value >> 24 & 0xFF);
        this.randomAccessFile.write(this.buffer, 0, 4);
    }

    public short readShort() throws IOException {
        this.randomAccessFile.readFully(this.buffer, 0, 2);
        return (short)(this.buffer[0] | this.buffer[1] << 8);
    }

    public void writeShort(short value) throws IOException {
        this.buffer[0] = (byte)(value & 0xFF);
        this.buffer[1] = (byte)(value >> 8 & 0xFF);
        this.randomAccessFile.write(this.buffer, 0, 2);
    }

    public byte readByte() throws IOException {
        this.randomAccessFile.readFully(this.buffer, 0, 1);
        return this.buffer[0];
    }

    public void writeByte(byte value) throws IOException {
        this.buffer[0] = value;
        this.randomAccessFile.write(this.buffer, 0, 1);
    }

    public char readChar() throws IOException {
        this.randomAccessFile.readFully(this.buffer, 0, 1);
        return (char)this.buffer[0];
    }

    public void writeChar(char value) throws IOException {
        this.buffer[0] = (byte)value;
        this.randomAccessFile.write(this.buffer, 0, 1);
    }

    public String readString(int length) throws IOException {
        byte[] result = new byte[length];
        this.randomAccessFile.read(result, 0, length);
        int start = 0;
        int end = 0;
        for (int i = result.length - 1; i >= 0; --i) {
            if (result[i] == 32) continue;
            end = i + 1;
            break;
        }
        return new String(result, start, end);
    }

    public void writeString(String value, int length) throws IOException {
        byte[] result = new byte[length];
        int start = 0;
        if (value != null) {
            byte[] data = value.getBytes();
            System.arraycopy(data, 0, result, 0, data.length);
            start = data.length;
        }
        for (int i = start; i < result.length; ++i) {
            result[i] = 32;
        }
        this.randomAccessFile.write(result, 0, length);
    }

    public void seek(long pos) throws IOException {
        this.randomAccessFile.seek(pos);
    }

    public int read(byte[] b) throws IOException {
        return this.randomAccessFile.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.randomAccessFile.read(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.randomAccessFile.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.randomAccessFile.write(b, off, len);
    }

    public long getFilePointer() throws IOException {
        return this.randomAccessFile.getFilePointer();
    }

    public long length() throws IOException {
        return this.randomAccessFile.length();
    }

    public void setLength(long value) throws IOException {
        this.randomAccessFile.setLength(value);
    }

    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.randomAccessFile;
    }

    public File getFile() {
        return this.file;
    }
}

