/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections.fileswapper;

import java.io.IOException;
import java.io.Serializable;
import org.brandao.brcache.collections.fileswapper.SimpleIndexEntityFile;

public class IndexKey
implements Serializable {
    private static final long serialVersionUID = 3595347631812335263L;
    private static final int[] charMap;
    public static final int LEN_NODES;
    public static final int DATA_SIZE;
    public static final long MAX_NODES;
    private long id = -1L;
    private long reference = -1L;
    private long[] nextNodes = new long[LEN_NODES];
    private boolean needUpdate = false;

    public IndexKey() {
        for (int i = 0; i < this.nextNodes.length; ++i) {
            this.nextNodes[i] = -1L;
        }
    }

    public void setNextNode(char id, IndexKey node) {
        int index = id & 0xFF;
        int charMapId = charMap[index];
        if (charMapId < 0) {
            throw new IllegalArgumentException("invalid char: " + id);
        }
        this.nextNodes[charMapId] = node.id;
        this.needUpdate = true;
    }

    public IndexKey getNextNode(char id, SimpleIndexEntityFile session) throws IOException {
        int index = id & 0xFF;
        int charMapId = charMap[index];
        if (charMapId < 0) {
            throw new IllegalArgumentException("invalid char: " + id);
        }
        long nexNode = this.nextNodes[charMapId];
        if (nexNode != -1L) {
            session.seek(nexNode);
            return (IndexKey)session.read();
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getReference() {
        return this.reference;
    }

    public void setReference(long reference) {
        this.reference = reference;
        this.needUpdate = true;
    }

    public long[] getNextNodes() {
        return this.nextNodes;
    }

    public void setNextNodes(long[] nextNodes) {
        this.nextNodes = nextNodes;
    }

    public boolean isNeedUpdate() {
        return this.needUpdate;
    }

    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate = needUpdate;
    }

    static {
        int index;
        int i;
        charMap = new int[256];
        for (int i2 = 0; i2 < charMap.length; ++i2) {
            IndexKey.charMap[i2] = -1;
        }
        int id = 0;
        for (i = 33; i <= 64; ++i) {
            index = i & 0xFF;
            IndexKey.charMap[index] = id++;
        }
        for (i = 91; i <= 126; ++i) {
            index = i & 0xFF;
            IndexKey.charMap[index] = id++;
        }
        for (i = 224; i <= 246; ++i) {
            index = i & 0xFF;
            IndexKey.charMap[index] = id++;
        }
        for (i = 249; i <= 253; ++i) {
            index = i & 0xFF;
            IndexKey.charMap[index] = id++;
        }
        IndexKey.charMap[255] = id++;
        LEN_NODES = id;
        DATA_SIZE = LEN_NODES * 8 + 18;
        MAX_NODES = Long.MAX_VALUE / (long)DATA_SIZE;
    }
}

