/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections.fileswapper;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.brandao.brcache.collections.fileswapper.AbstractEntityFile;
import org.brandao.brcache.collections.fileswapper.DataInputStream;
import org.brandao.brcache.collections.fileswapper.DataOutputStream;
import org.brandao.brcache.collections.fileswapper.IndexKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIndexEntityFile
extends AbstractEntityFile<IndexKey> {
    public static final byte LEN_HEADER = 11;
    public static final byte END_HEADER = 13;
    public static final byte EOF_FILE = 26;
    private ReadWriteLock lock;

    public SimpleIndexEntityFile(File file) {
        super(file);
        this.firstRecord = 11;
        this.recordLength = IndexKey.DATA_SIZE;
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    protected void writeEOF(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)26);
    }

    @Override
    protected void write(DataOutputStream stream, IndexKey entity) throws IOException {
        long[] page = entity.getNextNodes();
        stream.writeLong(entity.getId());
        stream.writeLong(entity.getReference());
        stream.writeShort((short)page.length);
        for (int i = 0; i < page.length; ++i) {
            stream.writeLong(page[i]);
        }
    }

    @Override
    protected IndexKey read(DataInputStream stream) throws IOException {
        IndexKey e = new IndexKey();
        e.setId(stream.readLong());
        e.setReference(stream.readLong());
        short pageLength = stream.readShort();
        long[] page = new long[pageLength];
        e.setNextNodes(page);
        for (int i = 0; i < page.length; ++i) {
            page[i] = stream.readLong();
        }
        return e;
    }

    @Override
    protected void writeMetaData(DataOutputStream stream) throws IOException {
        stream.writeString("SIDX", 6);
        stream.writeShort((short)11);
        stream.writeShort((short)IndexKey.DATA_SIZE);
        stream.writeByte((byte)13);
    }

    @Override
    protected void readMetaData(DataInputStream stream) throws IOException {
        String name = stream.readString(6);
        if (!"SIDX".equals(name)) {
            throw new IOException("invalid file format");
        }
        this.firstRecord = stream.readShort();
        this.recordLength = stream.readShort();
        byte end = stream.readByte();
        if (end != 13) {
            throw new IOException("header corrupted");
        }
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

