/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections.swapper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.brandao.brcache.collections.Collections;
import org.brandao.brcache.collections.DiskSwapper;
import org.brandao.brcache.collections.Entry;
import org.brandao.brcache.collections.Swapper;
import org.brandao.brcache.collections.fileswapper.DataBlockEntityFile;
import org.brandao.brcache.collections.fileswapper.DataBlockInputStream;
import org.brandao.brcache.collections.fileswapper.DataBlockOutputStream;
import org.brandao.brcache.collections.fileswapper.DataChain;
import org.brandao.brcache.collections.fileswapper.SimpleIndex;
import org.brandao.brcache.collections.fileswapper.SimpleIndexEntityFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSwapper
implements DiskSwapper {
    private static final long serialVersionUID = -9192895825998099336L;
    private String id;
    private String pathName;
    private File path;
    private SimpleIndex index = new SimpleIndex();
    private SimpleIndexEntityFile indexFile;
    private DataBlockEntityFile dataFile;
    private volatile boolean hasCreatePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sendItem(long index, Entry<?> item) {
        try {
            ObjectOutputStream oOut = null;
            DataBlockOutputStream bout = null;
            try {
                bout = new DataBlockOutputStream(this.dataFile.getBlockSize());
                oOut = new ObjectOutputStream(bout);
                oOut.writeObject(item.getItem());
                oOut.flush();
            }
            finally {
                if (oOut != null) {
                    oOut.flush();
                    oOut.close();
                }
            }
            String idx = Long.toString(index, 36);
            long reference = this.index.get(idx, this.indexFile);
            if (reference == -1L) {
                reference = DataChain.save(bout.getBlocks(), this.dataFile);
                this.index.registry(idx, reference, this.indexFile);
            } else {
                reference = DataChain.update(reference, bout.getBlocks(), this.dataFile);
                this.index.registry(idx, reference, this.indexFile);
            }
            this.dataFile.flush();
            this.indexFile.flush();
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Entry<?> getItem(long index) {
        Entry<Object> entry;
        block7: {
            String idx = Long.toString(index, 36);
            long reference = this.index.get(idx, this.indexFile);
            if (reference == -1L) {
                return null;
            }
            ObjectInputStream iIn = null;
            try {
                iIn = new ObjectInputStream(new DataBlockInputStream(reference, this.dataFile));
                Object item = iIn.readObject();
                Entry<Object> entry2 = new Entry<Object>(index, false, item);
                entry2.setNeedReload(false);
                entry = entry2;
                if (iIn == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (iIn != null) {
                        iIn.close();
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            }
            iIn.close();
        }
        return entry;
    }

    private synchronized void createPath() throws FileNotFoundException, IOException {
        if (this.hasCreatePath) {
            return;
        }
        File file = this.path = this.pathName == null ? Collections.getPath() : new File(this.pathName);
        if (!this.path.exists()) {
            this.path.mkdirs();
        }
        File idxFile = new File(this.path, this.id + ".idx");
        this.indexFile = new SimpleIndexEntityFile(idxFile);
        this.indexFile.createNewFile();
        File datFile = new File(this.path, this.id + ".dat");
        this.dataFile = new DataBlockEntityFile(datFile, 2048);
        this.dataFile.createNewFile();
        this.hasCreatePath = true;
    }

    @Override
    public void setRootPath(String value) {
        this.pathName = value;
    }

    @Override
    public String getRootPath() {
        return this.pathName;
    }

    @Override
    public void setId(String value) {
        try {
            this.id = value;
            this.createPath();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(value, e);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.id == null ? "" : this.id);
        stream.writeUTF(this.pathName == null ? "" : this.pathName);
        stream.writeBoolean(this.hasCreatePath);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.id = stream.readUTF();
        this.pathName = stream.readUTF();
        this.hasCreatePath = stream.readBoolean();
        this.id = this.id.isEmpty() ? null : this.id;
        String string = this.pathName = this.pathName.isEmpty() ? null : this.pathName;
        if (!this.hasCreatePath) {
            return;
        }
        File file = this.path = this.pathName == null ? Collections.getPath() : new File(this.pathName);
        if (!this.path.exists()) {
            this.path.mkdirs();
        }
        File idxFile = new File(this.path, this.id + ".idx");
        this.indexFile = new SimpleIndexEntityFile(idxFile);
        this.indexFile.open();
        File datFile = new File(this.path, this.id + ".dat");
        this.dataFile = new DataBlockEntityFile(datFile, 2048);
        this.dataFile.open();
        this.hasCreatePath = true;
    }

    @Override
    public void clear() {
        try {
            this.indexFile.createNewFile();
            this.dataFile.createNewFile();
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void destroy() {
        try {
            this.indexFile.close();
            this.indexFile.delete();
            this.dataFile.close();
            this.dataFile.delete();
            this.hasCreatePath = false;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Swapper clone() {
        try {
            return (Swapper)super.clone();
        }
        catch (Throwable e) {
            return null;
        }
    }
}

