/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections.swapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.brandao.brcache.collections.Collections;
import org.brandao.brcache.collections.DiskSwapper;
import org.brandao.brcache.collections.Entry;
import org.brandao.brcache.collections.Swapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeFileSwapper
implements DiskSwapper {
    private static final long serialVersionUID = -6050325151685902395L;
    public static final String PATH = "brcache.swapper.path";
    private String id;
    private String pathName = Collections.getConfiguration().getProperty("brcache.swapper.path");
    private transient File path;
    private transient boolean hasCreatePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendItem(long index, Entry<?> item) {
        try {
            if (!this.hasCreatePath) {
                this.createPath();
            }
            String dataPathName = this.getPath(String.valueOf(index));
            File dataPath = new File(this.path, dataPathName);
            TreeFileSwapper treeFileSwapper = this;
            synchronized (treeFileSwapper) {
                if (!dataPath.exists()) {
                    dataPath.mkdirs();
                }
            }
            File swp = new File(dataPath, index + ".swp");
            if (!swp.exists()) {
                swp.createNewFile();
            }
            ObjectOutputStream oOut = null;
            try {
                FileOutputStream out = new FileOutputStream(swp);
                oOut = new ObjectOutputStream(out);
                oOut.writeObject(item.getItem());
                oOut.flush();
            }
            finally {
                if (oOut != null) {
                    oOut.flush();
                    oOut.close();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry<?> getItem(long index) {
        Entry<Object> entry;
        block8: {
            String dataPathName;
            File dataPath;
            File swp;
            if (!this.hasCreatePath) {
                this.createPath();
            }
            if (!(swp = new File(dataPath = new File(this.path, dataPathName = this.getPath(String.valueOf(index))), index + ".swp")).exists()) {
                return null;
            }
            ObjectInputStream iIn = null;
            try {
                FileInputStream in = new FileInputStream(swp);
                iIn = new ObjectInputStream(in);
                Object item = iIn.readObject();
                Entry<Object> entry2 = new Entry<Object>(index, false, item);
                entry2.setNeedReload(false);
                entry = entry2;
                if (iIn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iIn != null) {
                        iIn.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            iIn.close();
        }
        return entry;
    }

    private synchronized void createPath() {
        if (this.hasCreatePath) {
            return;
        }
        File root = this.pathName == null ? Collections.getPath() : new File(this.pathName);
        this.path = new File(root, this.id);
        if (!this.path.exists()) {
            this.path.mkdirs();
        }
        this.hasCreatePath = true;
    }

    private String getPath(String str) {
        int length = str.length() / 4 > 1 ? str.length() / 4 : 3;
        String[] pathParts = new String[str.length() / length];
        int index = 0;
        for (int i = 0; i < pathParts.length; ++i) {
            int start = index;
            int end = index + length;
            pathParts[i] = str.substring(start, end < str.length() ? end : str.length());
            index += length;
        }
        StringBuilder persistedImagePathBuilder = new StringBuilder("");
        for (String path : pathParts) {
            persistedImagePathBuilder.append("/").append(path);
        }
        return persistedImagePathBuilder.toString();
    }

    public void setPath(String value) {
        this.pathName = value;
    }

    @Override
    public void setId(String value) {
        this.id = value;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void setRootPath(String path) {
        this.pathName = path;
    }

    @Override
    public String getRootPath() {
        return this.pathName;
    }

    @Override
    public void destroy() {
        File root = this.pathName == null ? Collections.getPath() : new File(this.pathName);
        File rootPath = new File(root, this.id);
        if (rootPath.exists()) {
            Collections.deleteDir(rootPath);
        }
    }

    @Override
    public Swapper clone() {
        try {
            return (Swapper)super.clone();
        }
        catch (Throwable e) {
            return null;
        }
    }
}

