/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections.treehugemap;

import org.brandao.brcache.collections.ReferenceCollection;
import org.brandao.brcache.collections.treehugemap.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharNode<T>
implements TreeNode<T> {
    private static final long serialVersionUID = 480902938041176366L;
    public static int MIN_CHARGROUP = 91;
    public static int MAX_CHARGROUP = 125;
    public static int LEN_CHARGROUP = MAX_CHARGROUP - MIN_CHARGROUP;
    public static int MIN_NUMBERGROUP = 33;
    public static int MAX_NUMBERGROUP = 63;
    public static int LEN_NUMBERGROUP = MAX_NUMBERGROUP - MIN_NUMBERGROUP;
    public static int MIN_CHAR2GROUP = 224;
    public static int MAX_CHAR2GROUP = 255;
    public static int LEN_CHAR2GROUP = MAX_CHAR2GROUP - MIN_CHAR2GROUP;
    public static int LEN_NODES = LEN_NUMBERGROUP + LEN_CHARGROUP + LEN_CHAR2GROUP;
    public static int DATA_SIZE = LEN_NODES * 8 + 16;
    public static final long MAX_NODES = Long.MAX_VALUE / (long)DATA_SIZE;
    private long id = -1L;
    private volatile long valueId = -1L;
    private long[] nextNodes = new long[LEN_NODES];

    public CharNode() {
        for (int i = 0; i < this.nextNodes.length; ++i) {
            this.nextNodes[i] = -1L;
        }
    }

    @Override
    public void setNext(ReferenceCollection<TreeNode<T>> nodes, Object key, TreeNode<T> node) {
        int c = ((Character)key).charValue();
        int index = c;
        if (index < MIN_CHARGROUP && index < MIN_NUMBERGROUP && index < MIN_CHAR2GROUP) {
            throw new IllegalArgumentException("invalid char: " + this.id);
        }
        if (index > MAX_CHARGROUP && index > MAX_NUMBERGROUP && index > MAX_CHAR2GROUP) {
            throw new IllegalArgumentException("invalid char: " + this.id);
        }
        index = index <= MAX_NUMBERGROUP ? (index -= MIN_NUMBERGROUP) : (index <= MAX_CHARGROUP ? LEN_NUMBERGROUP + (index - MIN_CHARGROUP) : LEN_NUMBERGROUP + LEN_CHARGROUP + (index - MIN_CHAR2GROUP));
        this.nextNodes[index] = node.getId();
        nodes.set(this.id, this);
    }

    @Override
    public TreeNode<T> getNext(ReferenceCollection<TreeNode<T>> nodes, Object key) {
        int c = ((Character)key).charValue();
        int index = c;
        if (index < MIN_CHARGROUP && index < MIN_NUMBERGROUP && index < MIN_CHAR2GROUP) {
            throw new IllegalArgumentException("invalid char: " + this.id);
        }
        if (index > MAX_CHARGROUP && index > MAX_NUMBERGROUP && index > MAX_CHAR2GROUP) {
            throw new IllegalArgumentException("invalid char: " + this.id);
        }
        index = index <= MAX_NUMBERGROUP ? (index -= MIN_NUMBERGROUP) : (index <= MAX_CHARGROUP ? LEN_NUMBERGROUP + (index - MIN_CHARGROUP) : LEN_NUMBERGROUP + LEN_CHARGROUP + (index - MIN_CHAR2GROUP));
        long nexNode = this.nextNodes[index];
        if (nexNode != -1L) {
            return nodes.get(nexNode);
        }
        return null;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public long getValueId() {
        return this.valueId;
    }

    @Override
    public T setValue(ReferenceCollection<T> values, T value) {
        if (this.valueId == -1L) {
            this.valueId = values.insert(value);
            return null;
        }
        T old = values.get(this.valueId);
        values.set(this.valueId, value);
        return old;
    }

    @Override
    public T removeValue(ReferenceCollection<T> values) {
        if (this.valueId != -1L) {
            T old = values.set(this.valueId, null);
            this.valueId = -1L;
            return old;
        }
        return null;
    }

    @Override
    public T getValue(ReferenceCollection<T> values) {
        long id = this.valueId;
        if (id != -1L) {
            return values.get(id);
        }
        return null;
    }

    @Override
    public boolean replaceValue(ReferenceCollection<T> values, T oldValue, T value) {
        if (this.valueId != -1L) {
            return values.replace(this.valueId, oldValue, value);
        }
        return false;
    }

    @Override
    public T replaceValue(ReferenceCollection<T> values, T value) {
        if (this.valueId != -1L) {
            return values.replace(this.valueId, value);
        }
        return null;
    }

    @Override
    public T putIfAbsentValue(ReferenceCollection<T> values, T value) {
        if (this.valueId != -1L) {
            return values.putIfAbsent(this.valueId, value);
        }
        this.valueId = values.insert(value);
        return null;
    }

    @Override
    public boolean removeValue(ReferenceCollection<T> values, T oldValue) {
        if (this.valueId != -1L) {
            boolean success = values.remove(this.valueId, oldValue);
            if (success) {
                this.valueId = -1L;
            }
            return success;
        }
        return false;
    }
}

