/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.collections.treehugemap;

import java.util.concurrent.locks.Lock;
import org.brandao.brcache.collections.ReferenceCollection;
import org.brandao.brcache.collections.RouletteLock;
import org.brandao.brcache.collections.treehugemap.CharNode;
import org.brandao.brcache.collections.treehugemap.TreeMapKey;
import org.brandao.brcache.collections.treehugemap.TreeNode;
import org.brandao.brcache.collections.treehugemap.TreeNodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTreeNodes<T>
implements TreeNodes<T> {
    private static final long serialVersionUID = -8387188156629418047L;
    private RouletteLock locks = new RouletteLock();
    private long firstNodeId = -1L;

    @Override
    public TreeMapKey getKey(Object key) {
        String strKey = (String)key;
        strKey = strKey.toLowerCase();
        StringTreeMapKey k = new StringTreeMapKey();
        k.index = strKey.toCharArray();
        k.limit = k.index.length;
        k.pos = 0;
        return k;
    }

    @Override
    public boolean isEquals(TreeMapKey key, TreeNode<T> node) {
        StringTreeMapKey k = (StringTreeMapKey)key;
        return k.pos == k.limit;
    }

    @Override
    public T getValue(ReferenceCollection<T> values, TreeNode<T> node) {
        return node.getValue(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T setValue(ReferenceCollection<T> values, TreeNode<T> node, T value) {
        Lock lock = this.locks.getLock(node.getId());
        lock.lock();
        try {
            T t = node.setValue(values, value);
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceValue(ReferenceCollection<T> values, TreeNode<T> node, T oldValue, T value) {
        Lock lock = this.locks.getLock(node.getId());
        lock.lock();
        try {
            boolean bl = node.replaceValue(values, oldValue, value);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T replaceValue(ReferenceCollection<T> values, TreeNode<T> node, T value) {
        Lock lock = this.locks.getLock(node.getId());
        lock.lock();
        try {
            T t = node.replaceValue(values, value);
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T putIfAbsentValue(ReferenceCollection<T> values, TreeNode<T> node, T value) {
        Lock lock = this.locks.getLock(node.getId());
        lock.lock();
        try {
            T t = node.putIfAbsentValue(values, value);
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T removeValue(ReferenceCollection<T> values, TreeNode<T> node) {
        Lock lock = this.locks.getLock(node.getId());
        lock.lock();
        try {
            T t = node.removeValue(values);
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeValue(ReferenceCollection<T> values, TreeNode<T> node, T oldValue) {
        Lock lock = this.locks.getLock(node.getId());
        lock.lock();
        try {
            boolean bl = node.removeValue(values, oldValue);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeNode<T> getNext(ReferenceCollection<TreeNode<T>> nodes, TreeMapKey key, TreeNode<T> node, boolean read) {
        char i;
        TreeNode<T> next;
        StringTreeMapKey k = (StringTreeMapKey)key;
        if ((next = node.getNext(nodes, Character.valueOf(i = k.index[k.pos++]))) == null && !read) {
            Lock lock = this.locks.getLock(node.getId());
            lock.lock();
            try {
                node = nodes.get(node.getId());
                next = node.getNext(nodes, Character.valueOf(i));
                if (next != null) {
                    TreeNode<T> treeNode = next;
                    return treeNode;
                }
                CharNode nextNode = new CharNode();
                long id = nodes.insert(nextNode);
                nextNode.setId(id);
                next = nextNode;
                node.setNext(nodes, Character.valueOf(i), nextNode);
            }
            finally {
                lock.unlock();
            }
        }
        return next;
    }

    @Override
    public TreeNode<T> getFirst(ReferenceCollection<TreeNode<T>> nodes) {
        return this.firstNodeId == -1L ? null : nodes.get(this.firstNodeId);
    }

    @Override
    public void init(ReferenceCollection<TreeNode<T>> nodes) {
        if (!nodes.isEmpty()) {
            throw new IllegalStateException();
        }
        CharNode node = new CharNode();
        node.setId(nodes.insert(node));
        nodes.set(node.getId(), node);
        this.firstNodeId = node.getId();
    }

    private static class StringTreeMapKey
    implements TreeMapKey {
        public char[] index;
        public int pos;
        public int limit;

        private StringTreeMapKey() {
        }
    }
}

