/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.memory;

import org.brandao.brcache.memory.HeapMemoryUtil;
import org.brandao.brcache.memory.HeapRegionMemory;
import org.brandao.brcache.memory.Memory;
import org.brandao.brcache.memory.RegionMemory;

public class HeapMemory
implements Memory {
    public RegionMemory alloc(long size) {
        byte[][] segs = HeapMemoryUtil.alloc(size);
        return new HeapRegionMemory(segs, HeapMemoryUtil.segmentSize, (int)size);
    }

    public void realloc(long size, RegionMemory region) {
        HeapRegionMemory r = (HeapRegionMemory)region;
        byte[][] segs = r.segments;
        byte[][] newSegs = HeapMemoryUtil.alloc(size);
        if (newSegs.length > segs.length) {
            System.arraycopy(segs, 0, newSegs, 0, segs.length);
            HeapMemoryUtil.free(segs);
            r.segments = newSegs;
            r.segmentSize = HeapMemoryUtil.segmentSize;
        } else {
            System.arraycopy(segs, 0, newSegs, 0, newSegs.length);
            HeapMemoryUtil.free(segs);
        }
    }

    public void alloc(long size, RegionMemory region) {
        HeapRegionMemory r = (HeapRegionMemory)region;
        if (r.segments != null) {
            throw new IllegalStateException();
        }
        this.allocSegments(size, r);
    }

    public void release(RegionMemory region) {
        HeapRegionMemory r = (HeapRegionMemory)region;
        if (r.segments == null) {
            return;
        }
        HeapMemoryUtil.free(r.segments);
        r.segments = null;
    }

    private HeapRegionMemory allocSegments(long size, HeapRegionMemory region) {
        byte[][] allocSegs = HeapMemoryUtil.alloc(size);
        region.length = size;
        region.segments = allocSegs;
        region.segmentSize = HeapMemoryUtil.segmentSize;
        return region;
    }
}

