/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.memory;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class HeapMemoryUtil {
    public static int segmentSize = 64;
    private static BlockingQueue<byte[]> segments = new LinkedBlockingQueue<byte[]>();

    public static byte[][] alloc(long size) {
        int quantity = (int)(size / (long)segmentSize);
        if (size % (long)segmentSize > 0L) {
            ++quantity;
        }
        byte[][] allocSegs = new byte[quantity][];
        for (int i = 0; i < quantity; ++i) {
            byte[] seg = HeapMemoryUtil.allocSegment();
            allocSegs[i] = seg;
        }
        return allocSegs;
    }

    public static void free(byte[][] allocSegs) {
        for (int i = 0; i < allocSegs.length; ++i) {
            segments.add(allocSegs[i]);
        }
    }

    private static byte[] allocSegment() {
        byte[] seg = (byte[])segments.poll();
        if (seg == null) {
            return new byte[segmentSize];
        }
        return seg;
    }
}

