/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.memory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.brandao.brcache.memory.HeapMemoryUtil;
import org.brandao.brcache.memory.RegionMemory;

public class HeapRegionMemory
implements RegionMemory {
    private static final long serialVersionUID = -8225524015808420667L;
    byte[][] segments;
    int segmentSize;
    long length;

    public HeapRegionMemory(byte[][] segments, int segmentSize, int length) {
        this.segments = segments;
        this.segmentSize = segmentSize;
        this.length = length;
    }

    byte[][] getSegments() {
        return this.segments;
    }

    public long size() {
        return this.length;
    }

    public byte get(long offset) {
        if (offset >= this.length) {
            throw new IndexOutOfBoundsException(offset + " >= " + this.length);
        }
        int seg = (int)(offset / (long)this.segmentSize);
        int off = (int)(offset % (long)this.segmentSize);
        return this.segments[seg][off];
    }

    public int read(long thisOff, byte[] buf, int off, int len) {
        if (thisOff >= this.length) {
            return -1;
        }
        len = (int)(thisOff + (long)len > this.length ? this.length - thisOff : (long)len);
        int thisSegmentId = (int)(thisOff / (long)this.segmentSize);
        byte[] thisCurrent = this.segments[thisSegmentId];
        int thisSegmentLimit = thisCurrent.length;
        int thisSegmentOff = (int)(thisOff % (long)this.segmentSize);
        int read = 0;
        int totalRead = 0;
        int maxOff = off + len;
        int needRead = 0;
        int maxRead = 0;
        int maxThisLen = 0;
        while (off < maxOff && thisOff < this.length) {
            if (thisSegmentOff >= thisSegmentLimit) {
                thisSegmentId = (int)(thisOff / (long)this.segmentSize);
                thisCurrent = this.segments[thisSegmentId];
                thisSegmentOff = (int)(thisOff % (long)this.segmentSize);
                thisSegmentLimit = thisCurrent.length;
            }
            maxThisLen = (int)(this.length - thisOff);
            needRead = maxOff - off;
            maxRead = thisSegmentLimit - thisSegmentOff;
            if (needRead > maxThisLen) {
                needRead = maxThisLen;
            }
            read = needRead > maxRead ? maxRead : needRead;
            System.arraycopy(thisCurrent, thisSegmentOff, buf, off, read);
            totalRead += read;
            thisSegmentOff += read;
            off += read;
            thisOff += (long)read;
        }
        return totalRead;
    }

    public long read(long thisOff, RegionMemory b, long off, long len) {
        HeapRegionMemory buf = (HeapRegionMemory)b;
        if (thisOff >= this.length) {
            return -1L;
        }
        int totalRead = 0;
        byte[][] segments = buf.segments;
        int segmentSize = buf.segmentSize;
        int thisSegmentId = (int)(thisOff / (long)this.segmentSize);
        byte[] thisCurrent = this.segments[thisSegmentId];
        int thisSegmentLimit = thisCurrent.length;
        int thisSegmentOff = (int)(thisOff % (long)this.segmentSize);
        int segmentId = (int)(off / (long)segmentSize);
        byte[] current = segments[segmentId];
        int segmentLimit = current.length;
        int segmentOff = (int)(off % (long)segmentSize);
        long maxOff = off + len;
        int transferLen = 0;
        int needRead = 0;
        int maxRead = 0;
        int maxThisLen = 0;
        int read = 0;
        long maxLen = 0L;
        int needWrite = 0;
        int maxWrite = 0;
        int write = 0;
        while (off < maxOff) {
            if (thisSegmentOff >= thisSegmentLimit) {
                thisSegmentId = (int)(thisOff / (long)this.segmentSize);
                thisCurrent = this.segments[thisSegmentId];
                thisSegmentOff = (int)(thisOff % (long)this.segmentSize);
                thisSegmentLimit = thisCurrent.length;
            }
            if (segmentOff >= segmentLimit) {
                segmentId = (int)(off / (long)segmentSize);
                current = segments[segmentId];
                segmentOff = (int)(off % (long)segmentSize);
                segmentLimit = current.length;
            }
            transferLen = (int)(maxOff - off);
            maxThisLen = (int)(this.length - thisOff);
            needRead = transferLen;
            maxRead = thisSegmentLimit - thisSegmentOff;
            if (needRead > maxThisLen) {
                needRead = maxThisLen;
            }
            read = needRead > maxRead ? maxRead : needRead;
            maxLen = buf.length - off;
            needWrite = transferLen;
            maxWrite = segmentLimit - segmentOff;
            if ((long)needWrite > maxLen) {
                throw new IndexOutOfBoundsException(needWrite + " > " + maxLen);
            }
            write = needWrite > maxWrite ? maxWrite : needWrite;
            int copy = maxWrite > maxRead ? read : write;
            if (copy == 0) break;
            System.arraycopy(thisCurrent, thisSegmentOff, current, segmentOff, copy);
            thisOff += (long)copy;
            off += (long)copy;
            thisSegmentOff += copy;
            segmentOff += copy;
            totalRead += copy;
        }
        return totalRead;
    }

    public void write(long thisOff, byte[] buf, int off, int len) {
        if (len == 0) {
            return;
        }
        long maxThisOff = this.length;
        int maxOff = off + len;
        if (maxOff > buf.length) {
            throw new IndexOutOfBoundsException(maxOff + " > " + buf.length);
        }
        int thisSegmentIndex = (int)(thisOff / (long)this.segmentSize);
        int thisSegmentOff = (int)(thisOff % (long)this.segmentSize);
        byte[] thisSegment = this.segments[thisSegmentIndex];
        int maxThisSegment = thisSegment.length;
        while (off < maxOff) {
            long maxWrite;
            int maxRead;
            if (thisSegmentOff >= maxThisSegment) {
                thisSegmentIndex = (int)(thisOff / (long)this.segmentSize);
                thisSegmentOff = (int)(thisOff % (long)this.segmentSize);
                thisSegment = this.segments[thisSegmentIndex];
                maxThisSegment = thisSegment.length;
            }
            if ((long)(maxRead = maxOff - off) > (maxWrite = maxThisOff - thisOff)) {
                throw new IndexOutOfBoundsException(maxOff + " > " + maxThisOff);
            }
            int maxSegmentWrite = maxThisSegment - thisSegmentOff;
            int copy = maxRead > maxSegmentWrite ? maxSegmentWrite : maxRead;
            System.arraycopy(buf, off, thisSegment, thisSegmentOff, copy);
            thisSegmentOff += copy;
            off += copy;
            thisOff += (long)copy;
        }
    }

    public void write(long thisOff, RegionMemory b, long off, long len) {
        HeapRegionMemory buf = (HeapRegionMemory)b;
        if (len == 0L) {
            return;
        }
        long maxThisOff = this.length;
        long maxOff = off + len;
        if (maxOff > buf.length) {
            throw new IndexOutOfBoundsException(maxOff + " > " + buf.length);
        }
        int thisSegmentIndex = (int)(thisOff / (long)this.segmentSize);
        int thisSegmentOff = (int)(thisOff % (long)this.segmentSize);
        byte[] thisSegment = this.segments[thisSegmentIndex];
        int maxThisSegment = thisSegment.length;
        int bufSegmentIndex = (int)(off / (long)this.segmentSize);
        int bufSegmentOff = (int)(off % (long)this.segmentSize);
        byte[] bufSegment = buf.segments[bufSegmentIndex];
        int maxBufSegment = bufSegment.length;
        while (off < maxOff) {
            long maxWrite;
            int maxRead;
            if (thisSegmentOff >= maxThisSegment) {
                thisSegmentIndex = (int)(thisOff / (long)this.segmentSize);
                thisSegmentOff = (int)(thisOff % (long)this.segmentSize);
                thisSegment = this.segments[thisSegmentIndex];
                maxThisSegment = thisSegment.length;
            }
            if (bufSegmentOff >= maxBufSegment) {
                bufSegmentIndex = (int)(off / (long)this.segmentSize);
                bufSegmentOff = (int)(off % (long)this.segmentSize);
                bufSegment = buf.segments[bufSegmentIndex];
                maxBufSegment = bufSegment.length;
            }
            if ((long)(maxRead = (int)(maxOff - off)) > (maxWrite = maxThisOff - thisOff)) {
                throw new IndexOutOfBoundsException(maxOff + " > " + maxThisOff);
            }
            int maxSegmentWrite = maxThisSegment - thisSegmentOff;
            int copy = maxRead > maxSegmentWrite ? maxSegmentWrite : maxRead;
            System.arraycopy(bufSegment, bufSegmentOff, thisSegment, thisSegmentOff, copy);
            bufSegmentOff += copy;
            thisSegmentOff += copy;
            off += (long)copy;
            thisOff += (long)copy;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeLong(this.length);
        stream.writeInt(this.segmentSize);
        for (byte[] b : this.segments) {
            stream.write(b);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.length = stream.readLong();
        this.segments = HeapMemoryUtil.alloc(this.length);
        this.segmentSize = HeapMemoryUtil.segmentSize;
        int segmentSize = stream.readInt();
        int thisOff = 0;
        byte[] b = new byte[segmentSize];
        while ((long)thisOff < this.length) {
            int len = stream.read(b, 0, b.length);
            int maxLen = (int)Math.min((long)b.length, this.length - (long)thisOff);
            this.write((long)thisOff, b, 0, maxLen);
            thisOff += len;
            if (len != 0) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            HeapMemoryUtil.free(this.segments);
        }
        finally {
            super.finalize();
        }
    }
}

