/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.memory;

import org.brandao.brcache.memory.Memory;
import org.brandao.brcache.memory.RegionMemory;
import org.brandao.brcache.memory.UnsafeMemoryUtil;
import org.brandao.brcache.memory.UnsafeRegionMemory;

public class UnsafeMemory
implements Memory {
    public RegionMemory alloc(long size) {
        long address = UnsafeMemoryUtil.alloc(size);
        return new UnsafeRegionMemory(address, size);
    }

    public void realloc(long size, RegionMemory region) {
        UnsafeRegionMemory r = (UnsafeRegionMemory)region;
        long address = UnsafeMemoryUtil.realloc(r.address, size);
        r.address = address;
    }

    public void alloc(long size, RegionMemory region) {
        UnsafeRegionMemory r = (UnsafeRegionMemory)region;
        if (r.address != null) {
            throw new IllegalStateException();
        }
        long address = UnsafeMemoryUtil.alloc(size);
        r.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(RegionMemory region) {
        RegionMemory regionMemory = region;
        synchronized (regionMemory) {
            UnsafeRegionMemory r = (UnsafeRegionMemory)region;
            if (r.address == null) {
                return;
            }
            UnsafeMemoryUtil.free(r.address);
            r.address = null;
        }
    }
}

