/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.memory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.brandao.brcache.memory.RegionMemory;
import org.brandao.brcache.memory.UnsafeMemoryUtil;

public class UnsafeRegionMemory
implements RegionMemory {
    private static final long serialVersionUID = 5941866368711530651L;
    Long address;
    long length;

    public UnsafeRegionMemory(long address, Long length) {
        this.address = address;
        this.length = length;
    }

    public long size() {
        return this.length;
    }

    public byte get(long off) {
        return UnsafeMemoryUtil.getByte(this.address, off);
    }

    public int read(long thisOff, byte[] buf, int off, int len) {
        int max = (int)(this.length - thisOff);
        max = max > len ? len : max;
        UnsafeMemoryUtil.arrayCopy((long)this.address, thisOff, buf, (long)off, (long)max);
        return max;
    }

    public long read(long thisOff, RegionMemory buf, long off, long len) {
        long max = this.length - thisOff;
        max = max > len ? len : max;
        UnsafeMemoryUtil.arrayCopy((long)this.address, thisOff, (long)((UnsafeRegionMemory)buf).address, off, max);
        return max;
    }

    public void write(long thisOff, byte[] buf, int off, int len) {
        long max = this.length - thisOff;
        max = max > (long)len ? (long)len : max;
        UnsafeMemoryUtil.arrayCopy(buf, (long)off, (long)this.address, thisOff, max);
    }

    public void write(long thisOff, RegionMemory buf, long off, long len) {
        long max = this.length - thisOff;
        max = max > len ? len : max;
        UnsafeMemoryUtil.arrayCopy((long)((UnsafeRegionMemory)buf).address, off, (long)this.address, thisOff, max);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        long len;
        stream.writeLong(this.length);
        byte[] b = new byte[9024];
        int off = 0;
        while ((len = (long)this.read((long)off, b, 0, b.length)) > 0L) {
            stream.write(b, 0, (int)len);
            off = (int)((long)off + len);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.length = stream.readLong();
        this.address = UnsafeMemoryUtil.alloc(this.length);
        int thisOff = 0;
        byte[] b = new byte[9024];
        while ((long)thisOff < this.length) {
            int maxLen = (int)Math.min((long)b.length, this.length - (long)thisOff);
            int len = stream.read(b, 0, maxLen);
            this.write((long)thisOff, b, 0, len);
            thisOff += len;
            if (len != 0) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            UnsafeRegionMemory unsafeRegionMemory = this;
            synchronized (unsafeRegionMemory) {
                if (this.address != null) {
                    UnsafeMemoryUtil.free(this.address);
                    this.address = null;
                }
            }
        }
        finally {
            super.finalize();
        }
    }
}

