/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.tx;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.brandao.brcache.BasicCache;
import org.brandao.brcache.CacheErrors;
import org.brandao.brcache.collections.Collections;
import org.brandao.brcache.tx.CacheTransactionHandler;
import org.brandao.brcache.tx.CacheTransactionHandlerImp;
import org.brandao.brcache.tx.CacheTransactionManager;
import org.brandao.brcache.tx.TransactionException;
import org.brandao.concurrent.NamedLock;

public class CacheTransactionManagerImp
implements CacheTransactionManager {
    private static final int TX_MAX_ID = 0x7FFFFFFD;
    private ThreadLocal<CacheTransactionHandler> transactions;
    private NamedLock locks;
    private ConcurrentMap<Serializable, Transaction> transactionLocks = new ConcurrentHashMap<Serializable, Transaction>();
    private String transactionPath;
    private File transactionFilePath;
    private long timeout;
    private int transactionIDs = 0;

    public CacheTransactionManagerImp() {
        this(null, -1L);
    }

    public CacheTransactionManagerImp(String transactionPath, long timeout) {
        this.locks = new NamedLock();
        this.transactions = new ThreadLocal();
        this.setPath(transactionPath);
        this.setTimeout(timeout);
    }

    public void lock(Serializable txId, String key) throws TransactionException {
        Serializable lockId = null;
        try {
            Transaction tx = (Transaction)this.transactionLocks.get(txId);
            if (!tx.locks.containsKey(key)) {
                lockId = this.locks.lock(key);
                tx.locks.put(key, lockId);
            }
        }
        catch (Throwable e) {
            if (lockId != null) {
                this.locks.unlock(lockId, key);
            }
            throw new TransactionException(e, CacheErrors.ERROR_1023, new Object[0]);
        }
    }

    public void tryLock(Serializable txId, String key, long time, TimeUnit unit) throws TransactionException {
        Serializable lockId = null;
        try {
            Transaction tx = (Transaction)this.transactionLocks.get(txId);
            if (!tx.locks.containsKey(key)) {
                lockId = this.locks.tryLock(key, time, unit);
                if (lockId == null) {
                    throw new TransactionException(CacheErrors.ERROR_1024, new Object[0]);
                }
                tx.locks.put(key, lockId);
            }
        }
        catch (Throwable e) {
            if (lockId != null) {
                this.locks.unlock(lockId, key);
            }
            throw e instanceof TransactionException ? (TransactionException)e : new TransactionException(e, CacheErrors.ERROR_1023, new Object[0]);
        }
    }

    public void unlock(Serializable txId, String key) throws TransactionException {
        Transaction tx = (Transaction)this.transactionLocks.get(txId);
        if (tx == null) {
            throw new TransactionException(CacheErrors.ERROR_1025, txId);
        }
        Serializable lockId = tx.locks.get(key);
        if (lockId == null) {
            throw new TransactionException(CacheErrors.ERROR_1026, txId, key);
        }
        try {
            this.locks.unlock(lockId, key);
            tx.locks.remove(key);
        }
        catch (Throwable e) {
            if (lockId != null) {
                this.locks.unlock(lockId, key);
            }
            throw e instanceof TransactionException ? (TransactionException)e : new TransactionException(e, CacheErrors.ERROR_1023, new Object[0]);
        }
    }

    public void commit(Serializable txId) throws TransactionException {
        Transaction tx = (Transaction)this.transactionLocks.get(txId);
        if (tx == null) {
            throw new TransactionException(CacheErrors.ERROR_1025, txId);
        }
        CacheTransactionHandler txHandler = tx.txHandler;
        txHandler.commit();
    }

    public void rollback(Serializable txId) throws TransactionException {
        Transaction tx = (Transaction)this.transactionLocks.get(txId);
        if (tx == null) {
            throw new TransactionException(CacheErrors.ERROR_1025, txId);
        }
        CacheTransactionHandler txHandler = tx.txHandler;
        txHandler.rollback();
    }

    public void setPath(String value) {
        if (value != null) {
            this.transactionPath = value;
            this.transactionFilePath = new File(this.transactionPath);
            Collections.deleteDir(this.transactionFilePath);
            this.transactionFilePath.mkdirs();
        } else {
            this.transactionPath = null;
            this.transactionFilePath = null;
        }
    }

    public String getPath() {
        return this.transactionPath;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long value) {
        this.timeout = value;
    }

    public CacheTransactionHandler begin(BasicCache cache) {
        CacheTransactionHandler txh = this.transactions.get();
        if (txh != null) {
            throw new TransactionException(CacheErrors.ERROR_1016, new Object[0]);
        }
        Serializable txId = this.createTransactionID();
        txh = new CacheTransactionHandlerImp(txId, this, cache, this.timeout);
        this.transactionLocks.put(txId, new Transaction(txh, new HashMap<String, Serializable>()));
        this.transactions.set(txh);
        txh.begin();
        return txh;
    }

    public CacheTransactionHandler getCurrrent() {
        return this.getCurrrent(true);
    }

    public CacheTransactionHandler getCurrrent(boolean required) {
        CacheTransactionHandler currentTX = this.transactions.get();
        if (currentTX == null && required) {
            throw new TransactionException(CacheErrors.ERROR_1013, new Object[0]);
        }
        return currentTX;
    }

    public void close(CacheTransactionHandler tx) throws TransactionException {
        CacheTransactionHandler current = this.transactions.get();
        if (current != tx) {
            throw new TransactionException(CacheErrors.ERROR_1027, new Object[0]);
        }
        Serializable txId = tx.getId();
        Transaction txInfo = (Transaction)this.transactionLocks.remove(txId);
        Map<String, Serializable> locks = txInfo.locks;
        for (String lockName : locks.keySet()) {
            Serializable ref = locks.get(lockName);
            this.locks.unlock(ref, lockName);
        }
        txInfo.txHandler.close();
        this.transactions.remove();
    }

    private synchronized Serializable createTransactionID() {
        int i = this.transactionIDs++;
        this.transactionIDs %= 0x7FFFFFFD;
        return Integer.toString(i, 36);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Transaction {
        public CacheTransactionHandler txHandler;
        public Map<String, Serializable> locks;

        public Transaction(CacheTransactionHandler txHandler, Map<String, Serializable> locks) {
            this.txHandler = txHandler;
            this.locks = locks;
        }
    }
}

