/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brcache.tx;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.brandao.brcache.BasicCache;
import org.brandao.brcache.Cache;
import org.brandao.brcache.CacheErrors;
import org.brandao.brcache.CacheException;
import org.brandao.brcache.RecoverException;
import org.brandao.brcache.StorageException;
import org.brandao.brcache.collections.Swapper;
import org.brandao.brcache.memory.Memory;
import org.brandao.brcache.tx.CacheTransaction;
import org.brandao.brcache.tx.CacheTransactionHandler;
import org.brandao.brcache.tx.CacheTransactionManager;
import org.brandao.brcache.tx.CacheTransactionManagerImp;

public class TXCache
extends Cache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long TIME_OUT = 300000L;
    private static final Method replace;
    private static final Method replaceStream;
    private static final Method replaceExact;
    private static final Method putIfAbsent;
    private static final Method putIfAbsentStream;
    private static final Method put;
    private static final Method putStream;
    private static final Method get;
    private static final Method getStream;
    private static final Method remove;
    private static final Method removeExact;
    private BasicCache cache;
    private CacheTransactionManager transactionManager;

    public TXCache(BasicCache cache) {
        this(cache, new CacheTransactionManagerImp(cache.getConfig().getDataPath() + "/tx", 300000L));
    }

    public TXCache(BasicCache cache, CacheTransactionManager transactionManager) {
        this.cache = cache;
        this.transactionManager = transactionManager;
    }

    protected void init(long nodeBufferSize, long nodePageSize, double nodeSwapFactor, long indexBufferSize, long indexPageSize, double indexSwapFactor, long dataBufferSize, long dataPageSize, long blockSize, double dataSwapFactor, long maxSizeEntry, int maxSizeKey, Swapper swapper, int quantitySwaperThread, Memory memory) {
        super.setDeleteOnExit(false);
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        throw new UnsupportedOperationException();
    }

    public CacheTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public long getTransactionTimeout() {
        return this.transactionManager.getTimeout();
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this.transactionManager.setTimeout(transactionTimeout);
    }

    public CacheTransaction beginTransaction() {
        return this.transactionManager.begin(this.cache);
    }

    public boolean replace(String key, Object value, long timeToLive, long timeToIdle) throws StorageException {
        try {
            return (Boolean)this.executeMethodInTX(replace, this.transactionManager.getCurrrent(false), this.transactionManager, this.cache, key, value, timeToLive, timeToIdle);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
    }

    public boolean replaceStream(String key, InputStream inputData, long timeToLive, long timeToIdle) throws StorageException {
        try {
            return (Boolean)this.executeMethodInTX(replaceStream, this.transactionManager.getCurrrent(false), this.transactionManager, this.cache, key, inputData, timeToLive, timeToIdle);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
    }

    public boolean replace(String key, Object oldValue, Object newValue, long timeToLive, long timeToIdle) throws StorageException {
        try {
            return (Boolean)this.executeMethodInTX(replaceExact, this.transactionManager.getCurrrent(false), this.transactionManager, this.cache, key, oldValue, newValue, timeToLive, timeToIdle);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
    }

    public Object putIfAbsent(String key, Object value, long timeToLive, long timeToIdle) throws StorageException {
        try {
            return this.executeMethodInTX(putIfAbsent, this.transactionManager.getCurrrent(false), this.transactionManager, this.cache, key, value, timeToLive, timeToIdle);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
    }

    public InputStream putIfAbsentStream(String key, InputStream inputData, long timeToLive, long timeToIdle) throws StorageException {
        try {
            return (InputStream)this.executeMethodInTX(putIfAbsentStream, this.transactionManager.getCurrrent(false), this.transactionManager, this.cache, key, inputData, timeToLive, timeToIdle);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
    }

    public boolean put(String key, Object value, long timeToLive, long timeToIdle) throws StorageException {
        try {
            return (Boolean)this.executeMethodInTX(put, this.transactionManager.getCurrrent(false), this.transactionManager, this.cache, key, value, timeToLive, timeToIdle);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
    }

    public boolean putStream(String key, InputStream inputData, long timeToLive, long timeToIdle) throws StorageException {
        try {
            return (Boolean)this.executeMethodInTX(putStream, this.transactionManager.getCurrrent(false), this.transactionManager, this.cache, key, inputData, timeToLive, timeToIdle);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
    }

    public Object get(String key) throws RecoverException {
        return this.get(key, false);
    }

    public Object get(String key, boolean forUpdate) throws RecoverException {
        try {
            return this.executeMethodInTX(get, this.transactionManager.getCurrrent(false), this.transactionManager, this.cache, key, forUpdate);
        }
        catch (RecoverException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new RecoverException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new RecoverException(e, CacheErrors.ERROR_1021, new Object[0]);
        }
    }

    public InputStream getStream(String key) throws RecoverException {
        return this.getStream(key, false);
    }

    public InputStream getStream(String key, boolean forUpdate) throws RecoverException {
        try {
            return (InputStream)this.executeMethodInTX(getStream, this.transactionManager.getCurrrent(false), this.transactionManager, this.cache, key, forUpdate);
        }
        catch (RecoverException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new RecoverException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new RecoverException(e, CacheErrors.ERROR_1021, new Object[0]);
        }
    }

    public boolean remove(String key, Object value) throws StorageException {
        try {
            return (Boolean)this.executeMethodInTX(removeExact, this.transactionManager.getCurrrent(false), this.transactionManager, this.cache, key, value);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
    }

    public boolean remove(String key) throws StorageException {
        try {
            return (Boolean)this.executeMethodInTX(remove, this.transactionManager.getCurrrent(false), this.transactionManager, this.cache, key);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new StorageException(e, e.getError(), e.getParams());
        }
        catch (Throwable e) {
            throw new StorageException(e, CacheErrors.ERROR_1020, new Object[0]);
        }
    }

    public long getCountRead() {
        return this.cache.getCountRead();
    }

    public long getCountWrite() {
        return this.cache.getCountWrite();
    }

    public long getCountRemoved() {
        return this.cache.getCountRemoved();
    }

    public long getCountReadData() {
        return this.cache.getCountReadData();
    }

    public long getCountWriteData() {
        return this.cache.getCountWriteData();
    }

    public long getCountRemovedData() {
        return this.cache.getCountRemovedData();
    }

    private Object executeMethodInTX(Method method, CacheTransactionHandler currentTx, Object ... params) throws Throwable {
        CacheTransactionHandler tx = currentTx == null ? this.transactionManager.begin(this.cache) : currentTx;
        try {
            Object r = method.invoke((Object)tx, params);
            if (currentTx == null) {
                tx.commit();
            }
            return r;
        }
        catch (IllegalAccessException e) {
            throw new CacheException(new Exception("bug!", e), CacheErrors.ERROR_1023, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new CacheException(new Exception("bug!", e), CacheErrors.ERROR_1023, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable ex = e.getTargetException();
            try {
                if (currentTx == null) {
                    tx.rollback();
                }
            }
            catch (Throwable x) {
                throw new CacheException(new Exception("bug: exception not recognized (rollback fail): " + x.toString(), ex), CacheErrors.ERROR_1018, new Object[0]);
            }
            if (ex instanceof StorageException || ex instanceof RecoverException) {
                throw ex;
            }
            throw new CacheException(new Exception("bug: exception not recognized: ", e), CacheErrors.ERROR_1023, new Object[0]);
        }
    }

    static {
        try {
            replace = CacheTransactionHandler.class.getDeclaredMethod("replace", CacheTransactionManager.class, BasicCache.class, String.class, Object.class, Long.TYPE, Long.TYPE);
            replaceStream = CacheTransactionHandler.class.getDeclaredMethod("replaceStream", CacheTransactionManager.class, BasicCache.class, String.class, InputStream.class, Long.TYPE, Long.TYPE);
            replaceExact = CacheTransactionHandler.class.getDeclaredMethod("replace", CacheTransactionManager.class, BasicCache.class, String.class, Object.class, Object.class, Long.TYPE, Long.TYPE);
            putIfAbsent = CacheTransactionHandler.class.getDeclaredMethod("putIfAbsent", CacheTransactionManager.class, BasicCache.class, String.class, Object.class, Long.TYPE, Long.TYPE);
            putIfAbsentStream = CacheTransactionHandler.class.getDeclaredMethod("putIfAbsentStream", CacheTransactionManager.class, BasicCache.class, String.class, InputStream.class, Long.TYPE, Long.TYPE);
            put = CacheTransactionHandler.class.getDeclaredMethod("put", CacheTransactionManager.class, BasicCache.class, String.class, Object.class, Long.TYPE, Long.TYPE);
            putStream = CacheTransactionHandler.class.getDeclaredMethod("putStream", CacheTransactionManager.class, BasicCache.class, String.class, InputStream.class, Long.TYPE, Long.TYPE);
            get = CacheTransactionHandler.class.getDeclaredMethod("get", CacheTransactionManager.class, BasicCache.class, String.class, Boolean.TYPE);
            getStream = CacheTransactionHandler.class.getDeclaredMethod("getStream", CacheTransactionManager.class, BasicCache.class, String.class, Boolean.TYPE);
            removeExact = CacheTransactionHandler.class.getDeclaredMethod("remove", CacheTransactionManager.class, BasicCache.class, String.class, Object.class);
            remove = CacheTransactionHandler.class.getDeclaredMethod("remove", CacheTransactionManager.class, BasicCache.class, String.class);
            replace.setAccessible(true);
            replaceExact.setAccessible(true);
            putIfAbsent.setAccessible(true);
            put.setAccessible(true);
            putStream.setAccessible(true);
            get.setAccessible(true);
            getStream.setAccessible(true);
            removeExact.setAccessible(true);
            remove.setAccessible(true);
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

