/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bremersee.comparator.model.ComparatorItem;
import org.bremersee.pagebuilder.PageBuilderUtils;
import org.bremersee.pagebuilder.PageControlFactory;
import org.bremersee.pagebuilder.model.Page;
import org.bremersee.pagebuilder.model.PageControlDto;
import org.bremersee.pagebuilder.model.PageRequestLinkDto;
import org.bremersee.pagebuilder.model.PageSizeSelectorOptionDto;
import org.bremersee.pagebuilder.model.PaginationDto;
import org.bremersee.utils.WebUtils;

class DefaultPageControlFactory
extends PageControlFactory {
    DefaultPageControlFactory() {
    }

    @Override
    public <E> PageControlDto newPageControl(Page<E> page, String pageUrl, Locale locale) {
        Validate.notNull(page, (String)"page must not be null", (Object[])new Object[0]);
        if (pageUrl == null) {
            pageUrl = "";
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (page.getEntries().size() == 0 && page.getPageRequest().getPageNumber() > 0) {
            throw new IllegalArgumentException("Building page control failed, because there are no entries and page number is greater than 0.");
        }
        PageControlDto pageControl = new PageControlDto();
        pageControl.setPage(PageBuilderUtils.createPageDto(page, null));
        pageControl.setPageNumberParamName(this.getPageNumberParamName());
        pageControl.setPageSizeParamName(this.getPageSizeParamName());
        pageControl.setComparatorParamName(this.getComparatorParamName());
        pageControl.setComparatorParamValue(this.getComparatorItemTransformer().toString(page.getPageRequest().getComparatorItem(), false, null));
        pageControl.setQueryParamName(this.getQueryParamName());
        pageControl.setQuerySupported(this.isQuerySupported());
        for (int pageNumber = 0; pageNumber < page.getTotalPages(); ++pageNumber) {
            PageRequestLinkDto pageRequestLink = new PageRequestLinkDto();
            pageRequestLink.setActive(pageNumber == page.getPageRequest().getPageNumber());
            pageRequestLink.setPageNumber(pageNumber);
            pageRequestLink.setUrl(this.buildUrl(pageUrl, pageNumber, page.getPageRequest().getPageSize(), page.getPageRequest().getComparatorItem(), page.getPageRequest().getQuery()));
            pageControl.getPageRequestLinks().add(pageRequestLink);
        }
        pageControl.setPageSizeSelectorOptions(this.buildPageSizeSelectorOptions(page.getPageRequest().getPageSize(), locale));
        pageControl.setPagination(this.buildPagination(page, pageControl.getPageRequestLinks(), pageUrl));
        return pageControl;
    }

    private String buildUrl(String url, int pageNo, int pageSize, ComparatorItem comparatorItem, String query) {
        String newUrl = WebUtils.addUrlParameter((String)url, (String)this.getPageNumberParamName(), (String)Integer.toString(pageNo));
        newUrl = WebUtils.addUrlParameter((String)newUrl, (String)this.getPageSizeParamName(), (String)Integer.toString(pageSize));
        String comparatorParamValue = this.getComparatorItemTransformer().toString(comparatorItem, false, null);
        if (StringUtils.isNotBlank((CharSequence)comparatorParamValue)) {
            newUrl = WebUtils.addUrlParameter((String)newUrl, (String)this.getComparatorParamName(), (String)comparatorParamValue);
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            newUrl = WebUtils.addUrlParameter((String)newUrl, (String)this.getQueryParamName(), (String)query);
        }
        return newUrl;
    }

    private <E> PaginationDto buildPagination(Page<E> page, List<PageRequestLinkDto> pageRequestLinks, String pageUrl) {
        int pageNumberOfFirstButton;
        Validate.notEmpty((CharSequence)pageUrl, (String)"pageUrl must not be empty", (Object[])new Object[0]);
        int maxPaginationLinks = this.getMaxPaginationLinks();
        if (maxPaginationLinks < 1) {
            maxPaginationLinks = 1;
        }
        if (page.getTotalPages() < maxPaginationLinks) {
            maxPaginationLinks = page.getTotalPages();
        }
        PaginationDto pagination = new PaginationDto();
        pagination.setMaxPaginationLinks(maxPaginationLinks);
        if (maxPaginationLinks % 2 == 0) {
            pageNumberOfFirstButton = page.getPageRequest().getPageNumber() - maxPaginationLinks / 2 + 1;
        } else {
            int middle = Double.valueOf(Math.floor((double)maxPaginationLinks / 2.0)).intValue();
            pageNumberOfFirstButton = page.getPageRequest().getPageNumber() - middle;
        }
        if (pageNumberOfFirstButton < 0) {
            pageNumberOfFirstButton = 0;
        }
        for (int pageNumber = pageNumberOfFirstButton; pageNumber < pageNumberOfFirstButton + maxPaginationLinks && pageNumber < page.getTotalPages(); ++pageNumber) {
            pagination.getLinks().add(pageRequestLinks.get(pageNumber));
        }
        while (page.getTotalPages() >= maxPaginationLinks && pageNumberOfFirstButton - 1 >= 0 && pagination.getLinks().size() < maxPaginationLinks) {
            pagination.getLinks().add(0, pageRequestLinks.get(--pageNumberOfFirstButton));
        }
        boolean firstPageDisabled = page.getPageRequest().getPageNumber() == 0;
        String firstPageUrl = firstPageDisabled ? "#" : this.buildUrl(pageUrl, 0, page.getPageRequest().getPageSize(), page.getPageRequest().getComparatorItem(), page.getPageRequest().getQuery());
        PageRequestLinkDto firstPage = new PageRequestLinkDto(pageRequestLinks.get(0), !firstPageDisabled, firstPageUrl);
        pagination.setFirstPageLink(firstPage);
        boolean previousPageDisabled = page.getPageRequest().getPageNumber() == 0;
        String previousPageUrl = previousPageDisabled ? "#" : this.buildUrl(pageUrl, page.getPageRequest().getPageNumber() - 1, page.getPageRequest().getPageSize(), page.getPageRequest().getComparatorItem(), page.getPageRequest().getQuery());
        int previousPageNumber = previousPageDisabled ? 0 : page.getPageRequest().getPageNumber() - 1;
        PageRequestLinkDto previousPage = new PageRequestLinkDto(pageRequestLinks.get(previousPageNumber), !previousPageDisabled, previousPageUrl);
        pagination.setPreviousPageLink(previousPage);
        boolean nextPageDisabled = page.getPageRequest().getPageNumber() == page.getTotalPages() - 1;
        String nextPageUrl = nextPageDisabled ? "#" : this.buildUrl(pageUrl, page.getPageRequest().getPageNumber() + 1, page.getPageRequest().getPageSize(), page.getPageRequest().getComparatorItem(), page.getPageRequest().getQuery());
        int nextPageNumber = nextPageDisabled ? page.getTotalPages() - 1 : page.getPageRequest().getPageNumber() + 1;
        PageRequestLinkDto nextPage = new PageRequestLinkDto(pageRequestLinks.get(nextPageNumber), !nextPageDisabled, nextPageUrl);
        pagination.setNextPageLink(nextPage);
        boolean lastPageDisabled = page.getPageRequest().getPageNumber() == page.getTotalPages() - 1;
        String lastPageUrl = lastPageDisabled ? "#" : this.buildUrl(pageUrl, page.getTotalPages() - 1, page.getPageRequest().getPageSize(), page.getPageRequest().getComparatorItem(), page.getPageRequest().getQuery());
        PageRequestLinkDto lastPage = new PageRequestLinkDto(pageRequestLinks.get(page.getTotalPages() - 1), !lastPageDisabled, lastPageUrl);
        pagination.setLastPageLink(lastPage);
        return pagination;
    }

    private List<PageSizeSelectorOptionDto> buildPageSizeSelectorOptions(int selectedPageSize, Locale locale) {
        int pageSizeSelectorMinValue = this.getPageSizeSelectorMinValue();
        int pageSizeSelectorMaxValue = this.getMaxResultsSelectorMaxValue();
        int pageSizeSelectorStep = this.getPageSizeSelectorStep();
        Validate.isTrue((0 < pageSizeSelectorMinValue && pageSizeSelectorMinValue <= pageSizeSelectorMaxValue ? 1 : 0) != 0, (String)"0 < pageSizeSelectorMinValue && pageSizeSelectorMinValue <= pageSizeSelectorMaxValue must be 'true'", (Object[])new Object[0]);
        if (pageSizeSelectorMaxValue > pageSizeSelectorMinValue) {
            Validate.isTrue((pageSizeSelectorStep > 0 ? 1 : 0) != 0, (String)"pageSizeSelectorStep > 0 must be 'true'", (Object[])new Object[0]);
        }
        Validate.isTrue((selectedPageSize > 0 ? 1 : 0) != 0, (String)"selectedMaxResults > 0 must be 'true'", (Object[])new Object[0]);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        boolean selctedValueAdded = false;
        TreeSet<PageSizeSelectorOptionDto> options = new TreeSet<PageSizeSelectorOptionDto>();
        for (int i = pageSizeSelectorMinValue; i <= pageSizeSelectorMaxValue; i += pageSizeSelectorStep) {
            if (i == selectedPageSize) {
                options.add(new PageSizeSelectorOptionDto(i, Integer.valueOf(i).toString(), true));
                selctedValueAdded = true;
                continue;
            }
            options.add(new PageSizeSelectorOptionDto(i, Integer.valueOf(i).toString(), false));
        }
        if (this.isSelectAllEntriesAvailable()) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("bremersee-pagebuilder-i18n", locale);
            String displayedValue = resourceBundle.containsKey("pageBuilderFactory.pageSizeSelector.max") ? resourceBundle.getString("pageBuilderFactory.pageSizeSelector.max") : "Max";
            if (Integer.MAX_VALUE == selectedPageSize) {
                options.add(new PageSizeSelectorOptionDto(Integer.MAX_VALUE, displayedValue, true));
                selctedValueAdded = true;
            } else {
                options.add(new PageSizeSelectorOptionDto(Integer.MAX_VALUE, displayedValue, false));
            }
        }
        if (!selctedValueAdded) {
            options.add(new PageSizeSelectorOptionDto(selectedPageSize, Integer.valueOf(selectedPageSize).toString(), true));
        }
        return Collections.unmodifiableList(new ArrayList(options));
    }
}

