/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.bremersee.comparator.ObjectComparatorFactory;
import org.bremersee.pagebuilder.PageBuilder;
import org.bremersee.pagebuilder.PageBuilderFilter;
import org.bremersee.pagebuilder.PageResult;
import org.bremersee.pagebuilder.model.PageRequest;
import org.bremersee.pagebuilder.model.PageRequestDto;

public class PageBuilderImpl
implements PageBuilder {
    private ObjectComparatorFactory objectComparatorFactory = ObjectComparatorFactory.newInstance();
    private PageBuilderFilter pageBuilderFilter;

    protected ObjectComparatorFactory getObjectComparatorFactory() {
        return this.objectComparatorFactory;
    }

    public void setObjectComparatorFactory(ObjectComparatorFactory objectComparatorFactory) {
        if (objectComparatorFactory != null) {
            this.objectComparatorFactory = objectComparatorFactory;
        }
    }

    protected PageBuilderFilter getPageBuilderFilter() {
        return this.pageBuilderFilter;
    }

    public void setPageBuilderFilter(PageBuilderFilter pageBuilderFilter) {
        this.pageBuilderFilter = pageBuilderFilter;
    }

    public String toString() {
        return "PageBuilderImpl [pageBuilderFilter=" + this.pageBuilderFilter + "]";
    }

    public <E> PageResult<E> buildPage(Collection<? extends E> pageEntries, PageRequest pageRequest, long totalSize) {
        return new PageResult<E>(pageEntries, pageRequest, totalSize);
    }

    public <E> PageResult<E> buildFilteredPage(Collection<? extends E> allAvailableEntries, PageRequest pageRequest, Object filterCriteria) {
        ArrayList<Object> filteredEntries;
        if (allAvailableEntries == null) {
            allAvailableEntries = new ArrayList<E>();
        }
        if (pageRequest == null) {
            pageRequest = new PageRequestDto();
        }
        ArrayList<E> allEntries = new ArrayList<E>(allAvailableEntries);
        if (pageRequest.getComparatorItem() != null) {
            Collections.sort(allEntries, this.objectComparatorFactory.newObjectComparator(pageRequest.getComparatorItem()));
        }
        if (this.getPageBuilderFilter() == null) {
            filteredEntries = allEntries;
        } else {
            filteredEntries = new ArrayList(allAvailableEntries.size());
            for (Object entry : allEntries) {
                if (!this.getPageBuilderFilter().accept(entry, filterCriteria)) continue;
                filteredEntries.add(entry);
            }
        }
        ArrayList pageEntries = new ArrayList(filteredEntries.size());
        if (pageRequest.getFirstResult() < filteredEntries.size()) {
            int lastResult = pageRequest.getFirstResult() + pageRequest.getPageSize();
            for (int i = pageRequest.getFirstResult(); i < lastResult; ++i) {
                if (i >= filteredEntries.size()) continue;
                pageEntries.add(filteredEntries.get(i));
            }
        }
        return new PageResult(pageEntries, pageRequest, filteredEntries.size());
    }
}

