/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.bremersee.pagebuilder.PageEntryTransformer;
import org.bremersee.pagebuilder.model.Page;
import org.bremersee.pagebuilder.model.PageDto;
import org.bremersee.pagebuilder.model.PageRequest;
import org.bremersee.pagebuilder.model.PageRequestDto;

public abstract class PageBuilderUtils {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();

    private PageBuilderUtils() {
    }

    public static <E, T> PageDto createPageDto(Page<E> page, PageEntryTransformer<T, E> transformer) {
        if (page == null) {
            return null;
        }
        if (page instanceof PageDto && transformer == null) {
            return (PageDto)page;
        }
        PageRequestDto pageRequestDto = PageBuilderUtils.createPageRequestDto(page.getPageRequest());
        if (transformer == null) {
            return new PageDto(page.getEntries(), pageRequestDto, page.getTotalSize());
        }
        ArrayList<T> entries = new ArrayList<T>();
        for (E e : page.getEntries()) {
            entries.add(transformer.transform(e));
        }
        return new PageDto(entries, pageRequestDto, page.getTotalSize());
    }

    public static PageRequestDto createPageRequestDto(PageRequest pageRequest) {
        PageRequestDto pageRequestDto = pageRequest == null ? null : (pageRequest instanceof PageRequestDto ? (PageRequestDto)pageRequest : new PageRequestDto(pageRequest));
        return pageRequestDto;
    }

    public static <T> T jsonMapToObject(Map<String, Object> map, Class<T> valueType, ObjectMapper objectMapper) throws IOException {
        if (map == null) {
            return null;
        }
        Validate.notNull(valueType, (String)"valueType must not be null", (Object[])new Object[0]);
        if (objectMapper == null) {
            objectMapper = DEFAULT_OBJECT_MAPPER;
        }
        return (T)objectMapper.readValue(objectMapper.writeValueAsBytes(map), valueType);
    }
}

