/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.pagebuilder;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.bremersee.comparator.ComparatorItemTransformer;
import org.bremersee.comparator.ComparatorItemTransformerImpl;
import org.bremersee.pagebuilder.DefaultPageControlFactory;
import org.bremersee.pagebuilder.PageBuilderUtils;
import org.bremersee.pagebuilder.PageEntryTransformer;
import org.bremersee.pagebuilder.model.Page;
import org.bremersee.pagebuilder.model.PageControlDto;

public abstract class PageControlFactory {
    protected static final String RESOURCE_BUNDLE_BASE_NAME = "bremersee-pagebuilder-i18n";
    public static final int DEFAULT_MAX_PAGINATION_LINKS = 7;
    public static final int DEFAULT_PAGE_SIZE_SELECTOR_MIN_VALUE = 10;
    public static final int DEFAULT_PAGE_SIZE_SELECTOR_MAX_VALUE = 100;
    public static final int DEFAULT_PAGE_SIZE_SELECTOR_STEP = 10;
    public static final boolean DEFAULT_SELECT_ALL_ENTRIES_AVAILABLE = true;
    private ComparatorItemTransformer comparatorItemTransformer = new ComparatorItemTransformerImpl();
    private String queryParamName = "q";
    private String pageSizeParamName = "s";
    private String pageNumberParamName = "p";
    private String comparatorParamName = "c";
    private int pageSizeSelectorMinValue = 10;
    private int pageSizeSelectorMaxValue = 100;
    private int pageSizeSelectorStep = 10;
    private boolean selectAllEntriesAvailable = true;
    private int maxPaginationLinks = 7;
    private boolean isQuerySupported = true;

    public static PageControlFactory newInstance() {
        return new DefaultPageControlFactory();
    }

    public static PageControlFactory newInstance(String factoryClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (PageControlFactory)Class.forName(factoryClassName).newInstance();
    }

    public static PageControlFactory newInstance(String factoryClassName, ClassLoader classLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (PageControlFactory)Class.forName(factoryClassName, true, classLoader).newInstance();
    }

    public ComparatorItemTransformer getComparatorItemTransformer() {
        return this.comparatorItemTransformer;
    }

    public PageControlFactory setComparatorItemTransformer(ComparatorItemTransformer comparatorItemTransformer) {
        if (comparatorItemTransformer != null) {
            this.comparatorItemTransformer = comparatorItemTransformer;
        }
        return this;
    }

    public String getQueryParamName() {
        return this.queryParamName;
    }

    public PageControlFactory setQueryParamName(String queryParamName) {
        if (StringUtils.isNotBlank((CharSequence)queryParamName)) {
            this.queryParamName = queryParamName;
        }
        return this;
    }

    public String getPageSizeParamName() {
        return this.pageSizeParamName;
    }

    public PageControlFactory setPageSizeParamName(String pageSizeParamName) {
        if (StringUtils.isNotBlank((CharSequence)pageSizeParamName)) {
            this.pageSizeParamName = pageSizeParamName;
        }
        return this;
    }

    public String getPageNumberParamName() {
        return this.pageNumberParamName;
    }

    public PageControlFactory setPageNumberParamName(String pageNumberParamName) {
        if (StringUtils.isNotBlank((CharSequence)pageNumberParamName)) {
            this.pageNumberParamName = pageNumberParamName;
        }
        return this;
    }

    public String getComparatorParamName() {
        return this.comparatorParamName;
    }

    public PageControlFactory setComparatorParamName(String comparatorParamName) {
        if (StringUtils.isNotBlank((CharSequence)comparatorParamName)) {
            this.comparatorParamName = comparatorParamName;
        }
        return this;
    }

    public int getPageSizeSelectorMinValue() {
        return this.pageSizeSelectorMinValue;
    }

    public PageControlFactory setPageSizeSelectorMinValue(int pageSizeSelectorMinValue) {
        this.pageSizeSelectorMinValue = pageSizeSelectorMinValue;
        return this;
    }

    public int getMaxResultsSelectorMaxValue() {
        return this.pageSizeSelectorMaxValue;
    }

    public PageControlFactory setPageSizeSelectorMaxValue(int pageSizeSelectorMaxValue) {
        this.pageSizeSelectorMaxValue = pageSizeSelectorMaxValue;
        return this;
    }

    public int getPageSizeSelectorStep() {
        return this.pageSizeSelectorStep;
    }

    public PageControlFactory setPageSizeSelectorStep(int pageSizeSelectorStep) {
        this.pageSizeSelectorStep = pageSizeSelectorStep;
        return this;
    }

    public boolean isSelectAllEntriesAvailable() {
        return this.selectAllEntriesAvailable;
    }

    public PageControlFactory setSelectAllEntriesAvailable(boolean selectAllEntriesAvailable) {
        this.selectAllEntriesAvailable = selectAllEntriesAvailable;
        return this;
    }

    public int getMaxPaginationLinks() {
        return this.maxPaginationLinks;
    }

    public PageControlFactory setMaxPaginationLinks(int maxPaginationLinks) {
        this.maxPaginationLinks = maxPaginationLinks;
        return this;
    }

    public boolean isQuerySupported() {
        return this.isQuerySupported;
    }

    public PageControlFactory setQuerySupported(boolean isQuerySupported) {
        this.isQuerySupported = isQuerySupported;
        return this;
    }

    public <E, T> PageControlDto newPageControl(Page<E> page, PageEntryTransformer<T, E> transformer, String pageUrl, Locale locale) {
        return this.newPageControl(PageBuilderUtils.createPageDto(page, transformer), pageUrl, locale);
    }

    public abstract <E> PageControlDto newPageControl(Page<E> var1, String var2, Locale var3);
}

